/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public class DestructibleBeanInstance<T> {
    private final T instance;
    private final InjectionTarget<T> injectionTarget;

    public DestructibleBeanInstance(BeanManager beanManager, Class<T> key) {
        this.injectionTarget = this.createInjectionTarget(beanManager, key);
        this.instance = this.createAndInjectBeans(beanManager, this.injectionTarget);
    }

    public T getInstance() {
        return this.instance;
    }

    public void destroy() {
        this.injectionTarget.preDestroy(this.instance);
        this.injectionTarget.dispose(this.instance);
    }

    private InjectionTarget<T> createInjectionTarget(BeanManager beanManager, Class<T> type2) {
        AnnotatedType<T> annotatedType = beanManager.createAnnotatedType(type2);
        return beanManager.createInjectionTarget(annotatedType);
    }

    private T createAndInjectBeans(BeanManager beanManager, InjectionTarget<T> injectionTarget) {
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Object instance = injectionTarget.produce(creationalContext);
        injectionTarget.inject(instance, creationalContext);
        injectionTarget.postConstruct(instance);
        return instance;
    }
}

