/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.tagext.JspTag;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ResourceLoaderImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.WeldTerminationListenerProxy;
import org.glassfish.weld.services.BootstrapConfigurationImpl;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.NonModuleInjectionServices;
import org.glassfish.weld.services.ProxyServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.glassfish.weld.util.Util;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jvnet.hk2.annotations.Service;

@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private Logger logger = Logger.getLogger(WeldDeployer.class.getName());
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "org.glassfish.weld.WeldBootstrap";
    private static final String WELD_CONTEXT_LISTENER = "org.glassfish.weld.WeldContextListener";
    private static final String WELD_LISTENER = "org.jboss.weld.servlet.WeldListener";
    static final String WELD_TERMINATION_LISTENER = "org.jboss.weld.servlet.WeldTerminalListener";
    private static final String WELD_SHUTDOWN = "weld_shutdown";
    private static final String WELD_BOOTSTRAP_SHUTDOWN = "weld_bootstrap_shutdown";
    private static final String WELD_CONVERSATION_FILTER_CLASS = "org.jboss.weld.servlet.ConversationFilter";
    private static final String WELD_CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    @Inject
    private Events events;
    @Inject
    private ServiceLocator services;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    ArchiveFactory archiveFactory;
    private Map<Application, WeldBootstrap> appToBootstrap = new HashMap<Application, WeldBootstrap>();
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();
    private static final Class<?>[] NON_CONTEXT_CLASSES = new Class[]{Servlet.class, ServletContextListener.class, Filter.class, HttpSessionListener.class, ServletRequestListener.class, JspTag.class};

    @Override
    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    @Override
    public void postConstruct() {
        this.events.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                DeploymentImpl deploymentImpl = appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
                deploymentImpl.buildDeploymentGraph();
                Collection archives = deploymentImpl.getBeanDeploymentArchives();
                for (BeanDeploymentArchive archive : archives) {
                    ResourceLoaderImpl loader = new ResourceLoaderImpl(((BeanDeploymentArchiveImpl)archive).getModuleClassLoaderForBDA());
                    archive.getServices().add(ResourceLoader.class, loader);
                }
                this.addCdiServicesToNonModuleBdas(deploymentImpl.getLibJarRootBdas(), this.services.getService(InjectionManager.class, new Annotation[0]));
                this.addCdiServicesToNonModuleBdas(deploymentImpl.getRarRootBdas(), this.services.getService(InjectionManager.class, new Annotation[0]));
                ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
                final String fAppName = appInfo.getName();
                this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                    @Override
                    public String getName() {
                        return fAppName;
                    }
                });
                try {
                    bootstrap.startExtensions(deploymentImpl.getExtensions());
                    bootstrap.startContainer(fAppName, Environments.SERVLET, deploymentImpl);
                    bootstrap.startInitialization();
                    this.fireProcessInjectionTargetEvents(bootstrap, deploymentImpl);
                    bootstrap.deployBeans();
                    bootstrap.validateBeans();
                    bootstrap.endInitialization();
                }
                catch (Throwable t) {
                    this.doBootstrapShutdown(appInfo);
                    String msgPrefix = this.getDeploymentErrorMsgPrefix(t);
                    DeploymentException de = new DeploymentException(msgPrefix + t.getMessage());
                    de.initCause(t);
                    throw de;
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                    Thread.currentThread().setContextClassLoader(oldTCL);
                    this.deploymentComplete(deploymentImpl);
                }
            }
        } else if (event.is(Deployment.APPLICATION_STOPPED) || event.is(Deployment.APPLICATION_UNLOADED) || event.is(Deployment.APPLICATION_DISABLED)) {
            DeploymentImpl deploymentImpl;
            ApplicationInfo appInfo;
            block24: {
                String shutdown;
                appInfo = (ApplicationInfo)event.hook();
                Application app = appInfo.getMetaData(Application.class);
                if (app != null) {
                    for (BundleDescriptor next : app.getBundleDescriptors()) {
                        if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                        this.bundleToBeanDeploymentArchive.remove(next);
                    }
                    this.appToBootstrap.remove(app);
                }
                if (Boolean.valueOf(shutdown = appInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)).equals(Boolean.TRUE)) {
                    return;
                }
                ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(appInfo.getAppClassLoader());
                try {
                    WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
                    if (bootstrap == null) break block24;
                    final String fAppName = appInfo.getName();
                    this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                        @Override
                        public String getName() {
                            return fAppName;
                        }
                    });
                    try {
                        this.doBootstrapShutdown(appInfo);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, "AS-CDI-00036", new Object[]{e});
                    }
                    finally {
                        this.invocationManager.popAppEnvironment();
                    }
                    appInfo.addTransientAppMetaData(WELD_SHUTDOWN, "true");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
            }
            if ((deploymentImpl = appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) != null) {
                deploymentImpl.cleanup();
            }
        }
    }

    private void deploymentComplete(DeploymentImpl deploymentImpl) {
        for (BeanDeploymentArchive oneBda : deploymentImpl.getBeanDeploymentArchives()) {
            ((BeanDeploymentArchiveImpl)oneBda).setDeploymentComplete(true);
        }
    }

    private void doBootstrapShutdown(ApplicationInfo appInfo) {
        WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        String bootstrapShutdown = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, String.class);
        if (bootstrapShutdown == null || Boolean.valueOf(bootstrapShutdown).equals(Boolean.FALSE)) {
            bootstrap.shutdown();
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, "true");
        }
    }

    private String getDeploymentErrorMsgPrefix(Throwable t) {
        if (t instanceof DefinitionException) {
            return "CDI definition failure:";
        }
        if (t instanceof javax.enterprise.inject.spi.DeploymentException) {
            return "CDI deployment failure:";
        }
        Throwable cause = t.getCause();
        if (cause == t || cause == null) {
            return "CDI deployment failure:";
        }
        return this.getDeploymentErrorMsgPrefix(cause);
    }

    private void fireProcessInjectionTargetEvents(WeldBootstrap bootstrap, DeploymentImpl impl) {
        Collection bdaList = impl.getBeanDeploymentArchives();
        boolean isFullProfile = false;
        Class<?> messageListenerClass = null;
        try {
            messageListenerClass = Thread.currentThread().getContextClassLoader().loadClass("javax.jms.MessageListener");
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00037");
            }
            isFullProfile = true;
        }
        catch (ClassNotFoundException cnfe) {
            isFullProfile = false;
        }
        for (BeanDeploymentArchive bda : bdaList) {
            Collection<Class<?>> bdaClasses = ((BeanDeploymentArchiveImpl)bda).getBeanClassObjects();
            for (Class<?> bdaClazz : bdaClasses) {
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(bdaClazz)) continue;
                    this.firePITEvent(bootstrap, bda, bdaClazz);
                }
                if (!isFullProfile || !messageListenerClass.isAssignableFrom(bdaClazz)) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00038", new Object[]{bdaClazz});
                }
                this.firePITEvent(bootstrap, bda, bdaClazz);
            }
        }
    }

    private void firePITEvent(WeldBootstrap bootstrap, BeanDeploymentArchive bda, Class<?> bdaClazz) {
        if (bdaClazz.isInterface()) {
            return;
        }
        AnnotatedType<?> at = bootstrap.getManager(bda).createAnnotatedType(bdaClazz);
        InjectionTarget<?> it = bootstrap.getManager(bda).fireProcessInjectionTarget(at);
        ((BeanDeploymentArchiveImpl)bda).putInjectionTarget(at, it);
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle2) {
        return this.bundleToBeanDeploymentArchive.get(bundle2);
    }

    public boolean is299Enabled(BundleDescriptor bundle2) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle2);
    }

    public WeldBootstrap getBootstrapForApp(Application app) {
        return this.appToBootstrap.get(app);
    }

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    public <V> V loadMetaData(Class<V> type2, DeploymentContext context) {
        return null;
    }

    @Override
    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        BeanDeploymentArchive bda;
        DeploymentImpl deploymentImpl;
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        ApplicationInfo appInfo = this.applicationRegistry.get(deployParams.name);
        ReadableArchive archive = context.getSource();
        WeldBootstrap bootstrap = context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        if (bootstrap == null) {
            bootstrap = new WeldBootstrap();
            Application app = context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
            context.addTransientAppMetaData(WELD_BOOTSTRAP, bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP, bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, "false");
        }
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        if (ejbBundle != null) {
            ejbs.addAll(ejbBundle.getEjbs());
            ejbServices = new EjbServicesImpl(this.services);
        }
        boolean isSubArchive = archive.getParentArchive() != null;
        String archiveName = !isSubArchive ? appInfo.getName() : archive.getName();
        int suffixIdx = archiveName.lastIndexOf(45);
        if (isSubArchive && suffixIdx > 0) {
            archiveName = archiveName.substring(0, suffixIdx);
            if (!context.getArchiveHandler().getArchiveType().isEmpty()) {
                archiveName = String.format("%s.%s", archiveName, context.getArchiveHandler().getArchiveType());
            }
        }
        if ((deploymentImpl = context.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) == null) {
            deploymentImpl = new DeploymentImpl(archive, ejbs, context, this.archiveFactory, archiveName);
            TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.services);
            deploymentImpl.getServices().add(TransactionServices.class, transactionServices);
            SecurityServicesImpl securityServices = new SecurityServicesImpl();
            deploymentImpl.getServices().add(SecurityServices.class, securityServices);
            ProxyServicesImpl proxyServices = new ProxyServicesImpl(this.services);
            deploymentImpl.getServices().add(ProxyServices.class, proxyServices);
            BootstrapConfigurationImpl bootstrapConfiguration = new BootstrapConfigurationImpl();
            deploymentImpl.getServices().add(BootstrapConfiguration.class, bootstrapConfiguration);
            this.addWeldListenerToAllWars(context);
        } else {
            deploymentImpl.scanArchive(archive, ejbs, context, archiveName);
        }
        deploymentImpl.addDeployedEjbs(ejbs);
        if (ejbBundle != null && !deploymentImpl.getServices().contains(EjbServices.class)) {
            deploymentImpl.getServices().add(EjbServices.class, ejbServices);
        }
        if ((bda = deploymentImpl.getBeanDeploymentArchiveForArchive(archiveName)) != null && !bda.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            CommonResourceBundleDescriptor bundle2;
            WebBundleDescriptor wDesc = context.getModuleMetaData(WebBundleDescriptor.class);
            if (wDesc != null) {
                wDesc.setExtensionProperty(WELD_EXTENSION, "true");
                wDesc.addAppListenerDescriptorToFirst(new AppListenerDescriptorImpl(WELD_LISTENER));
                wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WELD_CONTEXT_LISTENER));
                wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WeldTerminationListenerProxy.class.getName()));
                for (ServletFilterMapping sfMapping : wDesc.getServletFilterMappings()) {
                    String displayName = ((ServletFilterMappingDescriptor)sfMapping).getDisplayName();
                    if (!WELD_CONVERSATION_FILTER_NAME.equals(displayName)) continue;
                    ServletFilterDescriptor ref = new ServletFilterDescriptor();
                    ref.setClassName(WELD_CONVERSATION_FILTER_CLASS);
                    ref.setName(WELD_CONVERSATION_FILTER_NAME);
                    wDesc.addServletFilter(ref);
                    break;
                }
            }
            CommonResourceBundleDescriptor commonResourceBundleDescriptor = bundle2 = wDesc != null ? wDesc : ejbBundle;
            if (bundle2 != null) {
                if (!bda.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
                    InjectionManager injectionMgr = this.services.getService(InjectionManager.class, new Annotation[0]);
                    InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionMgr, bundle2, deploymentImpl);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, bda.getId()});
                    }
                    bda.getServices().add(InjectionServices.class, injectionServices);
                    for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, subBda.getId()});
                        }
                        subBda.getServices().add(InjectionServices.class, injectionServices);
                    }
                }
                this.bundleToBeanDeploymentArchive.put(bundle2, bda);
            }
        }
        WeldApplicationContainer wbApp = new WeldApplicationContainer();
        context.addTransientAppMetaData(WELD_DEPLOYMENT, deploymentImpl);
        appInfo.addTransientAppMetaData(WELD_DEPLOYMENT, deploymentImpl);
        return wbApp;
    }

    private void addWeldListenerToAllWars(DeploymentContext context) {
        ApplicationHolder applicationHolder = context.getModuleMetaData(ApplicationHolder.class);
        if (applicationHolder != null && applicationHolder.app.getBundleDescriptors(EjbBundleDescriptor.class).size() > 0) {
            Set<WebBundleDescriptor> webBundleDescriptors = applicationHolder.app.getBundleDescriptors(WebBundleDescriptor.class);
            for (WebBundleDescriptor oneWebBundleDescriptor : webBundleDescriptors) {
                oneWebBundleDescriptor.addAppListenerDescriptorToFirst(new AppListenerDescriptorImpl(WELD_LISTENER));
                oneWebBundleDescriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(WeldTerminationListenerProxy.class.getName()));
            }
        }
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection<EjbBundleDescriptor> ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = ejbBundles.iterator().next();
        }
        return ejbBundle;
    }

    private void addCdiServicesToNonModuleBdas(Iterator<RootBeanDeploymentArchive> rootBdas, InjectionManager injectionMgr) {
        if (injectionMgr != null && rootBdas != null) {
            while (rootBdas.hasNext()) {
                RootBeanDeploymentArchive oneRootBda = rootBdas.next();
                this.addCdiServicesToBda(injectionMgr, oneRootBda);
                this.addCdiServicesToBda(injectionMgr, oneRootBda.getModuleBda());
            }
        }
    }

    private void addCdiServicesToBda(InjectionManager injectionMgr, BeanDeploymentArchive bda) {
        NonModuleInjectionServices injectionServices = new NonModuleInjectionServices(injectionMgr);
        bda.getServices().add(InjectionServices.class, injectionServices);
    }

    static {
        try {
            Util.initializeWeldSingletonProvider();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

