/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private Logger logger = Logger.getLogger(BeanDeploymentArchiveImpl.class.getName());
    private ReadableArchive archive;
    private String id;
    private List<String> moduleClassNames = null;
    private List<String> beanClassNames = null;
    private List<Class<?>> moduleClasses = null;
    private List<Class<?>> beanClasses = null;
    private List<URL> beansXmlURLs = null;
    private final Collection<EjbDescriptor<?>> ejbDescImpls;
    private List<BeanDeploymentArchive> beanDeploymentArchives;
    private SimpleServiceRegistry simpleServiceRegistry = null;
    private WeldUtils.BDAType bdaType = WeldUtils.BDAType.UNKNOWN;
    private DeploymentContext context;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> itMap = new HashMap();
    private ClassLoader moduleClassLoaderForBDA = null;
    private String friendlyId = "";
    private Collection<String> cdiAnnotatedClassNames = null;
    private boolean deploymentComplete = false;

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this(archive, ejbs, ctx, null);
    }

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx, String bdaID) {
        this.beanClasses = new ArrayList();
        this.beanClassNames = new ArrayList<String>();
        this.moduleClasses = new ArrayList();
        this.moduleClassNames = new ArrayList<String>();
        this.beansXmlURLs = new CopyOnWriteArrayList<URL>();
        this.archive = archive;
        this.id = bdaID == null ? archive.getName() : bdaID;
        this.friendlyId = this.id;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        this.populate(ejbs, ctx.getModuleMetaData(Application.class));
        this.populateEJBsForThisBDA(ejbs);
        try {
            this.archive.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.archive = null;
        this.getClassLoader();
    }

    private void populateEJBsForThisBDA(Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            for (String className : this.moduleClassNames) {
                if (!className.equals(next.getEjbClassName())) continue;
                EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
                this.ejbDescImpls.add(wbEjbDesc);
            }
        }
    }

    public BeanDeploymentArchiveImpl(String id, List<Class<?>> wClasses, List<URL> beansXmlUrls, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this.id = id;
        this.moduleClasses = wClasses;
        this.beanClasses = new ArrayList(wClasses);
        this.moduleClassNames = new ArrayList<String>();
        this.beanClassNames = new ArrayList<String>();
        for (Class<?> c : wClasses) {
            this.moduleClassNames.add(c.getName());
            this.beanClassNames.add(c.getName());
        }
        this.beansXmlURLs = beansXmlUrls;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        this.populateEJBsForThisBDA(ejbs);
        this.getClassLoader();
    }

    @Override
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    @Override
    public Collection<String> getBeanClasses() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "AS-CDI-00001", new Object[]{this.id, this.moduleClassLoaderForBDA});
        }
        if (!this.isDeploymentComplete()) {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoaderForBDA);
        }
        return this.beanClassNames;
    }

    public Collection<Class<?>> getBeanClassObjects() {
        return this.beanClasses;
    }

    public Collection<String> getModuleBeanClasses() {
        return this.beanClassNames;
    }

    public Collection<Class<?>> getModuleBeanClassObjects() {
        return this.moduleClasses;
    }

    public void addBeanClass(String beanClassName) {
        boolean added = false;
        for (String c : this.moduleClassNames) {
            if (!c.equals(beanClassName)) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00002", new Object[]{c, this.beanClassNames});
            }
            this.beanClassNames.add(c);
            try {
                this.beanClasses.add(this.getClassLoader().loadClass(c));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            added = true;
        }
        if (!added && this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00003", new Object[]{beanClassName});
        }
    }

    @Override
    public BeansXml getBeansXml() {
        BeansXml result = null;
        WeldBootstrap wb = this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        result = this.beansXmlURLs.size() == 1 ? wb.parse(this.beansXmlURLs.get(0)) : wb.parse(this.beansXmlURLs);
        return result;
    }

    @Override
    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescImpls;
    }

    public EjbDescriptor getEjbDescriptor(String ejbName) {
        EjbDescriptor<?> match = null;
        for (EjbDescriptor<?> next : this.ejbDescImpls) {
            if (!next.getEjbName().equals(ejbName)) continue;
            match = next;
            break;
        }
        return match;
    }

    @Override
    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public String toString() {
        String beanClassesString = this.getBeanClasses().size() > 0 ? this.getBeanClasses().toString() : "";
        String initVal = "|ID: " + this.getId() + ", bdaType= " + (Object)((Object)this.bdaType) + ", accessibleBDAs #:" + this.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(this) + ", Bean Classes #: " + this.getBeanClasses().size() + "," + beanClassesString + ", ejbs=" + this.getEjbs() + "\n";
        StringBuffer valBuff = new StringBuffer(initVal);
        Collection<BeanDeploymentArchive> bdas = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : bdas) {
            WeldUtils.BDAType embedBDAType = WeldUtils.BDAType.UNKNOWN;
            if (bda instanceof BeanDeploymentArchiveImpl) {
                embedBDAType = ((BeanDeploymentArchiveImpl)bda).getBDAType();
            }
            String embedBDABeanClasses = bda.getBeanClasses().size() > 0 ? bda.getBeanClasses().toString() : "";
            String val = "|---->ID: " + bda.getId() + ", bdaType= " + embedBDAType.toString() + ", accessibleBDAs #:" + bda.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(bda) + ", Bean Classes #: " + bda.getBeanClasses().size() + "," + embedBDABeanClasses + ", ejbs=" + bda.getEjbs() + "\n";
            valBuff.append(val);
        }
        return valBuff.toString();
    }

    private String formatAccessibleBDAs(BeanDeploymentArchive bda) {
        StringBuffer sb = new StringBuffer("[");
        for (BeanDeploymentArchive accessibleBDA : bda.getBeanDeploymentArchives()) {
            if (!(accessibleBDA instanceof BeanDeploymentArchiveImpl)) continue;
            sb.append(((BeanDeploymentArchiveImpl)accessibleBDA).getFriendlyId() + ",");
        }
        sb.append("]");
        return sb.toString();
    }

    public WeldUtils.BDAType getBDAType() {
        return this.bdaType;
    }

    private void populate(Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, Application app) {
        try {
            Enumeration<String> entries;
            URI webinfclasses;
            BeanDiscoveryMode bdMode;
            BeansXml beansXML;
            boolean webinfbda = false;
            boolean hasBeansXml = false;
            String beansXMLURL = null;
            if (this.archive.exists("WEB-INF/beans.xml")) {
                beansXMLURL = "WEB-INF/beans.xml";
            }
            if (beansXMLURL == null && this.archive.exists("WEB-INF/classes/META-INF/beans.xml")) {
                beansXMLURL = "WEB-INF/classes/META-INF/beans.xml";
            }
            if (beansXMLURL != null) {
                beansXML = this.parseBeansXML(this.archive, beansXMLURL);
                bdMode = beansXML.getBeanDiscoveryMode();
                if (!bdMode.equals((Object)BeanDiscoveryMode.NONE)) {
                    webinfbda = true;
                    boolean bl = hasBeansXml = !bdMode.equals((Object)BeanDiscoveryMode.ANNOTATED);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "AS-CDI-00004", new Object[]{this.archive.getURI(), "WEB-INF/beans.xml", "WEB-INF/classes/META-INF/beans.xml"});
                    }
                } else {
                    this.addBeansXMLURL(this.archive, beansXMLURL);
                }
            } else if (this.archive.exists("WEB-INF/classes") && WeldUtils.isImplicitBeanArchive(this.context, webinfclasses = new File(this.context.getSourceDir().getAbsolutePath(), "WEB-INF/classes").toURI())) {
                webinfbda = true;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00028", new Object[]{this.archive.getURI()});
                }
            }
            if (webinfbda) {
                this.bdaType = WeldUtils.BDAType.WAR;
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    if (this.legalClassName(entry)) {
                        if (entry.contains("WEB-INF/classes")) {
                            entry = entry.substring("WEB-INF/classes".length() + 1);
                        }
                        String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                        try {
                            if (hasBeansXml || this.isCDIAnnotatedClass(className)) {
                                this.beanClassNames.add(className);
                                this.beanClasses.add(this.getClassLoader().loadClass(className));
                            }
                            this.moduleClassNames.add(className);
                        }
                        catch (Throwable t) {
                            if (!this.logger.isLoggable(Level.WARNING)) continue;
                            this.logger.log(Level.WARNING, "AS-CDI-00005", new Object[]{className, t.toString()});
                        }
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    this.addBeansXMLURL(this.archive, entry);
                }
                this.archive.close();
            }
            if (this.archive.exists("WEB-INF/lib")) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00006", new Object[]{this.archive.getURI()});
                }
                this.bdaType = WeldUtils.BDAType.WAR;
                entries = this.archive.entries("WEB-INF/lib");
                ArrayList<ReadableArchive> weblibJarsThatAreBeanArchives = new ArrayList<ReadableArchive>();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    if (!entry.endsWith(".jar") || entry.indexOf(47, "WEB-INF/lib".length() + 1) != -1 || app != null && !DOLUtils.isScanningAllowed(app, entry)) continue;
                    ReadableArchive weblibJarArchive = this.archive.getSubArchive(entry);
                    if (weblibJarArchive.exists("META-INF/beans.xml")) {
                        BeansXml beansXML2 = this.parseBeansXML(weblibJarArchive, "META-INF/beans.xml");
                        BeanDiscoveryMode bdMode2 = beansXML2.getBeanDiscoveryMode();
                        if (bdMode2.equals((Object)BeanDiscoveryMode.NONE)) continue;
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "AS-CDI-00007", new Object[]{entry});
                        }
                        if (bdMode2.equals((Object)BeanDiscoveryMode.ANNOTATED) && !WeldUtils.isImplicitBeanArchive(this.context, weblibJarArchive)) continue;
                        weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                        continue;
                    }
                    if (WeldUtils.isImplicitBeanArchive(this.context, weblibJarArchive)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "AS-CDI-00007", new Object[]{entry});
                        }
                        weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                        continue;
                    }
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.log(Level.FINE, "AS-CDI-00008", new Object[]{this.archive.getName()});
                }
                ArrayList<BeanDeploymentArchiveImpl> webLibBDAs = new ArrayList<BeanDeploymentArchiveImpl>();
                if (weblibJarsThatAreBeanArchives.size() > 0) {
                    ListIterator libJarIterator = weblibJarsThatAreBeanArchives.listIterator();
                    while (libJarIterator.hasNext()) {
                        ReadableArchive libJarArchive = (ReadableArchive)libJarIterator.next();
                        BeanDeploymentArchiveImpl wlbda = new BeanDeploymentArchiveImpl(libJarArchive, ejbs, this.context, "WEB-INF/lib/" + libJarArchive.getName());
                        this.beanDeploymentArchives.add(wlbda);
                        webLibBDAs.add(wlbda);
                    }
                }
                this.ensureWebLibJarVisibility(webLibBDAs);
            } else if (this.archive.getName().endsWith(".rar") || this.archive.getName().endsWith("_rar")) {
                this.bdaType = WeldUtils.BDAType.RAR;
                this.collectRarInfo(this.archive);
            } else if (this.archive.exists("META-INF/beans.xml")) {
                beansXML = this.parseBeansXML(this.archive, "META-INF/beans.xml");
                bdMode = beansXML.getBeanDiscoveryMode();
                if (!bdMode.equals((Object)BeanDiscoveryMode.NONE)) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "AS-CDI-00009", new Object[]{this.archive.getURI()});
                    }
                    this.bdaType = WeldUtils.BDAType.JAR;
                    this.collectJarInfo(this.archive, true, !bdMode.equals((Object)BeanDiscoveryMode.ANNOTATED));
                } else {
                    this.addBeansXMLURL(this.archive, "META-INF/beans.xml");
                }
            } else if (WeldUtils.isImplicitBeanArchive(this.context, this.archive)) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00029", new Object[]{this.archive.getURI()});
                }
                this.bdaType = WeldUtils.BDAType.JAR;
                this.collectJarInfo(this.archive, true, false);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
    }

    private void ensureWebLibJarVisibility(List<BeanDeploymentArchiveImpl> webLibBDAs) {
        int i;
        for (i = 0; i < webLibBDAs.size(); ++i) {
            BeanDeploymentArchiveImpl firstBDA = webLibBDAs.get(i);
            boolean modified = false;
            for (int j = 0; j < webLibBDAs.size(); ++j) {
                BeanDeploymentArchiveImpl otherBDA = webLibBDAs.get(j);
                if (firstBDA.getId().equals(otherBDA.getId())) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00030", new Object[]{firstBDA.getFriendlyId(), otherBDA.getFriendlyId()});
                }
                firstBDA.getBeanDeploymentArchives().add(otherBDA);
                modified = true;
            }
            if (!modified) continue;
            int idx = this.beanDeploymentArchives.indexOf(firstBDA);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00031", new Object[]{firstBDA.getFriendlyId()});
            }
            if (idx < 0) continue;
            this.beanDeploymentArchives.set(idx, firstBDA);
        }
        for (i = 0; i < webLibBDAs.size(); ++i) {
            int idx;
            BeanDeploymentArchiveImpl subBDA = webLibBDAs.get(i);
            subBDA.getBeanDeploymentArchives().add(this);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00032", new Object[]{subBDA.getId(), this.getId()});
            }
            if ((idx = this.beanDeploymentArchives.indexOf(subBDA)) < 0) continue;
            this.beanDeploymentArchives.set(idx, subBDA);
        }
    }

    private void collectJarInfo(ReadableArchive archive, boolean isBeanArchive, boolean hasBeansXml) throws IOException, ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00013", new Object[]{archive.getURI()});
        }
        Enumeration<String> entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = entries.nextElement();
            this.handleEntry(archive, entry, isBeanArchive, hasBeansXml);
        }
    }

    private void handleEntry(ReadableArchive archive, String entry, boolean isBeanArchive, boolean hasBeansXml) throws ClassNotFoundException {
        block9: {
            if (this.legalClassName(entry)) {
                String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                try {
                    if (isBeanArchive && (hasBeansXml || this.isCDIAnnotatedClass(className))) {
                        this.beanClasses.add(this.getClassLoader().loadClass(className));
                        this.beanClassNames.add(className);
                    }
                    this.moduleClassNames.add(className);
                }
                catch (Throwable t) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "AS-CDI-00005", new Object[]{className, t.toString()});
                    }
                    break block9;
                }
            }
            if (entry.endsWith("/beans.xml")) {
                try {
                    URLClassLoader throwAwayClassLoader = new URLClassLoader(new URL[]{archive.getURI().toURL()}, null);
                    URL beansXmlUrl = throwAwayClassLoader.getResource(entry);
                    if (beansXmlUrl != null && !this.beansXmlURLs.contains(beansXmlUrl)) {
                        this.beansXmlURLs.add(beansXmlUrl);
                    }
                }
                catch (MalformedURLException e) {
                    if (!this.logger.isLoggable(Level.SEVERE)) break block9;
                    this.logger.log(Level.SEVERE, "AS-CDI-00033", new Object[]{e.getMessage()});
                }
            }
        }
    }

    private boolean legalClassName(String className) {
        return className.endsWith(".class") && !className.startsWith("WEB-INF/lib");
    }

    private void collectRarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00015", new Object[]{archive.getURI()});
        }
        Enumeration<String> entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = entries.nextElement();
            if (entry.endsWith(".jar")) {
                ReadableArchive jarArchive = archive.getSubArchive(entry);
                this.collectJarInfo(jarArchive, true, true);
                continue;
            }
            this.handleEntry(archive, entry, true, true);
        }
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl;
        if (this.context.getClassLoader() != null) {
            cl = this.context.getClassLoader();
        } else if (Thread.currentThread().getContextClassLoader() != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Using TCL");
            }
            cl = Thread.currentThread().getContextClassLoader();
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00034");
            }
            cl = BeanDeploymentArchiveImpl.class.getClassLoader();
        }
        this.moduleClassLoaderForBDA = cl;
        return cl;
    }

    public InjectionTarget<?> getInjectionTarget(AnnotatedType<?> annotatedType) {
        return this.itMap.get(annotatedType);
    }

    void putInjectionTarget(AnnotatedType<?> annotatedType, InjectionTarget<?> it) {
        this.itMap.put(annotatedType, it);
    }

    public ClassLoader getModuleClassLoaderForBDA() {
        return this.moduleClassLoaderForBDA;
    }

    private boolean isCDIAnnotatedClass(String className) {
        if (this.cdiAnnotatedClassNames == null) {
            this.cdiAnnotatedClassNames = WeldUtils.getCDIAnnotatedClassNames(this.context);
        }
        return this.cdiAnnotatedClassNames.contains(className);
    }

    protected BeansXml parseBeansXML(ReadableArchive archive, String beansXMLPath) throws IOException {
        WeldBootstrap wb = this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        URL url = this.getBeansXMLFileURL(archive, beansXMLPath);
        BeansXml result = wb.parse(url);
        try {
            Field[] fields;
            Class<?> clazz = Class.forName("sun.net.www.protocol.jar.JarFileFactory", true, URL.class.getClassLoader());
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!"fileCache".equals(field.getName())) continue;
                field.setAccessible(true);
                HashMap files = (HashMap)field.get(null);
                HashSet jars = new HashSet();
                jars.addAll(files.values());
                for (JarFile file : jars) {
                    file.close();
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private void addBeansXMLURL(ReadableArchive archive, String beansXMLPath) throws IOException {
        URL beansXmlUrl = this.getBeansXMLFileURL(archive, beansXMLPath);
        if (!this.beansXmlURLs.contains(beansXmlUrl)) {
            this.beansXmlURLs.add(beansXmlUrl);
        }
    }

    private URL getBeansXMLFileURL(ReadableArchive archive, String beansXMLPath) throws IOException {
        URL url = null;
        File file = new File(archive.getURI().getPath());
        if (file.isDirectory()) {
            file = new File(file, beansXMLPath);
            url = file.toURI().toURL();
        } else {
            url = new URL("jar:" + file.toURI() + "!/" + beansXMLPath);
        }
        return url;
    }

    public boolean isDeploymentComplete() {
        return this.deploymentComplete;
    }

    public void setDeploymentComplete(boolean deploymentComplete) {
        this.deploymentComplete = deploymentComplete;
    }
}

