/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.javamail.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Session;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.api.GlobalResourceDeployer;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.ResourcePropertyImpl;
import org.glassfish.resources.javamail.config.MailResource;
import org.glassfish.resources.javamail.naming.MailNamingObjectFactory;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=MailResource.class)
@Singleton
public class MailResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    private static final StringManager localStrings = StringManager.getManager(MailResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(MailResourceDeployer.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        MailResource mailRes = (MailResource)resource;
        if (mailRes == null) {
            _logger.log(Level.INFO, "Error in resource deploy.");
        } else {
            ResourceInfo resourceInfo = new ResourceInfo(mailRes.getJndiName(), applicationName, moduleName);
            this.installResource(mailRes, resourceInfo);
        }
    }

    @Override
    public synchronized void deployResource(Object resource) throws Exception {
        MailResource mailResource = (MailResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(mailResource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    void installResource(MailResource mailResource, ResourceInfo resourceInfo) throws Exception {
        JavaEEResource j2eeRes = MailResourceDeployer.toMailJavaEEResource(mailResource, resourceInfo);
        this.installMailResource((org.glassfish.resources.javamail.beans.MailResource)j2eeRes, resourceInfo);
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        MailResource mailRes = (MailResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(mailRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(mailRes, resourceInfo);
    }

    @Override
    public synchronized void undeployResource(Object resource) throws Exception {
        MailResource mailRes = (MailResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(mailRes);
        this.deleteResource(mailRes, resourceInfo);
    }

    private void deleteResource(MailResource mailRes, ResourceInfo resourceInfo) throws NamingException {
        this.namingService.unpublishObject(resourceInfo, mailRes.getJndiName());
    }

    @Override
    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof MailResource;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installMailResource(org.glassfish.resources.javamail.beans.MailResource mailResource, ResourceInfo resourceInfo) {
        try {
            MailConfiguration config = new MailConfiguration(mailResource);
            Reference ref = new Reference(Session.class.getName(), MailNamingObjectFactory.class.getName(), null);
            SerializableObjectRefAddr serializableRefAddr = new SerializableObjectRefAddr("jndiName", config);
            ref.add(serializableRefAddr);
            this.namingService.publishObject(resourceInfo, ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error", resourceInfo);
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", ex);
        }
    }

    public static JavaEEResource toMailJavaEEResource(MailResource mailResourceConfig, ResourceInfo resourceInfo) {
        org.glassfish.resources.javamail.beans.MailResource mailResource = new org.glassfish.resources.javamail.beans.MailResource(resourceInfo);
        mailResource.setEnabled(Boolean.valueOf(mailResourceConfig.getEnabled()));
        mailResource.setStoreProtocol(mailResourceConfig.getStoreProtocol());
        mailResource.setStoreProtocolClass(mailResourceConfig.getStoreProtocolClass());
        mailResource.setTransportProtocol(mailResourceConfig.getTransportProtocol());
        mailResource.setTransportProtocolClass(mailResourceConfig.getTransportProtocolClass());
        mailResource.setMailHost(mailResourceConfig.getHost());
        mailResource.setUsername(mailResourceConfig.getUser());
        mailResource.setMailFrom(mailResourceConfig.getFrom());
        mailResource.setDebug(Boolean.valueOf(mailResourceConfig.getDebug()));
        List<Property> properties = mailResourceConfig.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), property.getValue());
                mailResource.addProperty(rp);
            }
        }
        return mailResource;
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

