/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.api;

import org.glassfish.resourcebase.resources.api.GenericResourceInfo;

public class ResourceInfo
implements GenericResourceInfo {
    private String name;
    private String applicationName = null;
    private String moduleName = null;

    public ResourceInfo(String name) {
        this.name = name;
    }

    public ResourceInfo(String name, String applicationName) {
        this.name = name;
        this.applicationName = applicationName;
    }

    public ResourceInfo(String name, String applicationName, String moduleName) {
        this.name = name;
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public String toString() {
        if (this.applicationName != null && this.moduleName != null) {
            return "{ ResourceInfo : (jndiName=" + this.name + "), (applicationName=" + this.applicationName + "), (moduleName=" + this.moduleName + ")}";
        }
        if (this.applicationName != null) {
            return "{ ResourceInfo : (jndiName=" + this.name + "), (applicationName=" + this.applicationName + ") }";
        }
        return this.name;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o == this) {
            result = true;
        } else if (o instanceof ResourceInfo) {
            ResourceInfo resourceInfo = (ResourceInfo)o;
            boolean poolNameEqual = resourceInfo.getName().equals(this.name);
            boolean appNameEqual = false;
            if (this.applicationName == null && resourceInfo.getApplicationName() == null) {
                appNameEqual = true;
            } else if (this.applicationName != null && resourceInfo.getApplicationName() != null && this.applicationName.equals(resourceInfo.getApplicationName())) {
                appNameEqual = true;
            }
            boolean moduleNameEqual = false;
            if (this.moduleName == null && resourceInfo.getModuleName() == null) {
                moduleNameEqual = true;
            } else if (this.moduleName != null && resourceInfo.getModuleName() != null && this.moduleName.equals(resourceInfo.getModuleName())) {
                moduleNameEqual = true;
            }
            result = poolNameEqual && appNameEqual && moduleNameEqual;
        }
        return result;
    }

    public int hashCode() {
        int result = 67;
        if (this.name != null) {
            result = 67 * result + this.name.hashCode();
        }
        if (this.applicationName != null) {
            result = 67 * result + this.applicationName.hashCode();
        }
        if (this.moduleName != null) {
            result = 67 * result + this.moduleName.hashCode();
        }
        return result;
    }
}

