/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.ImplicitViewable;
import org.glassfish.jersey.server.mvc.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.internal.TemplateHelper;
import org.glassfish.jersey.server.mvc.spi.ResolvedViewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;
import org.glassfish.jersey.server.mvc.spi.ViewableContext;
import org.glassfish.jersey.server.mvc.spi.ViewableContextException;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
final class ViewableMessageBodyWriter
implements MessageBodyWriter<Viewable> {
    @Inject
    private ServiceLocator serviceLocator;
    @Context
    private javax.inject.Provider<ExtendedUriInfo> extendedUriInfoProvider;
    @Context
    private javax.inject.Provider<ContainerRequest> requestProvider;
    @Context
    private javax.inject.Provider<ResourceInfo> resourceInfoProvider;
    private static final Logger LOGGER = Logger.getLogger(ViewableMessageBodyWriter.class.getName());

    ViewableMessageBodyWriter() {
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Viewable.class.isAssignableFrom(type2);
    }

    @Override
    public long getSize(Viewable viewable, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Viewable viewable, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            ResolvedViewable resolvedViewable = this.resolve(viewable);
            if (resolvedViewable == null) {
                String message = LocalizationMessages.TEMPLATE_NAME_COULD_NOT_BE_RESOLVED(viewable.getTemplateName());
                throw new WebApplicationException((Throwable)new ProcessingException(message), Response.Status.NOT_FOUND);
            }
            httpHeaders.putSingle("Content-Type", resolvedViewable.getMediaType());
            resolvedViewable.writeTo(entityStream, httpHeaders);
        }
        catch (ViewableContextException vce) {
            throw new NotFoundException(vce);
        }
    }

    private ResolvedViewable resolve(Viewable viewable) {
        if (viewable instanceof ResolvedViewable) {
            return (ResolvedViewable)viewable;
        }
        ViewableContext viewableContext = this.getViewableContext();
        Set<TemplateProcessor> templateProcessors = this.getTemplateProcessors();
        List<MediaType> producibleMediaTypes = TemplateHelper.getProducibleMediaTypes(this.requestProvider.get(), this.extendedUriInfoProvider.get(), null);
        Class<?> resourceClass = this.resourceInfoProvider.get().getResourceClass();
        if (viewable instanceof ImplicitViewable) {
            ImplicitViewable implicitViewable = (ImplicitViewable)viewable;
            for (String templateName : implicitViewable.getTemplateNames()) {
                Viewable simpleViewable = new Viewable(templateName, viewable.getModel());
                ResolvedViewable resolvedViewable = this.resolve(simpleViewable, producibleMediaTypes, implicitViewable.getResolvingClass(), viewableContext, templateProcessors);
                if (resolvedViewable == null) continue;
                return resolvedViewable;
            }
        } else {
            return this.resolve(viewable, producibleMediaTypes, resourceClass, viewableContext, templateProcessors);
        }
        return null;
    }

    private ResolvedViewable resolve(Viewable viewable, List<MediaType> mediaTypes, Class<?> resolvingClass, ViewableContext viewableContext, Set<TemplateProcessor> templateProcessors) {
        for (TemplateProcessor templateProcessor : templateProcessors) {
            for (MediaType mediaType : mediaTypes) {
                ResolvedViewable resolvedViewable = viewableContext.resolveViewable(viewable, mediaType, resolvingClass, templateProcessor);
                if (resolvedViewable == null) continue;
                return resolvedViewable;
            }
        }
        return null;
    }

    private Set<TemplateProcessor> getTemplateProcessors() {
        LinkedHashSet<TemplateProcessor> templateProcessors = Sets.newLinkedHashSet();
        templateProcessors.addAll(Providers.getCustomProviders(this.serviceLocator, TemplateProcessor.class));
        templateProcessors.addAll(Providers.getProviders(this.serviceLocator, TemplateProcessor.class));
        return templateProcessors;
    }

    private ViewableContext getViewableContext() {
        Set<ViewableContext> customProviders = Providers.getCustomProviders(this.serviceLocator, ViewableContext.class);
        if (!customProviders.isEmpty()) {
            return customProviders.iterator().next();
        }
        return Providers.getProviders(this.serviceLocator, ViewableContext.class).iterator().next();
    }
}

