/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Collections;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.Http2Frame;

public class WindowUpdateFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<WindowUpdateFrame> CACHE_IDX = ThreadCache.obtainIndex(WindowUpdateFrame.class, 8);
    public static final int TYPE = 8;
    private int windowSizeIncrement;

    private WindowUpdateFrame() {
    }

    static WindowUpdateFrame create() {
        WindowUpdateFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new WindowUpdateFrame();
        }
        return frame;
    }

    public static Http2Frame fromBuffer(int flags, int streamId, Buffer frameBuffer) {
        WindowUpdateFrame frame = WindowUpdateFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        frame.setFrameBuffer(frameBuffer);
        frame.windowSizeIncrement = frameBuffer.getInt() & Integer.MAX_VALUE;
        return frame;
    }

    public static WindowUpdateFrameBuilder builder() {
        return new WindowUpdateFrameBuilder();
    }

    public int getWindowSizeIncrement() {
        return this.windowSizeIncrement;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WindowUpdateFrame {").append(this.headerToString()).append(", windowSizeIncrement=").append(this.windowSizeIncrement).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return 4;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return Collections.emptyMap();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.windowSizeIncrement = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        Object buffer = http2Connection.getMemoryManager().allocate(http2Connection.getFrameHeaderSize() + 4);
        http2Connection.serializeHttp2FrameHeader(this, (Buffer)buffer);
        buffer.putInt(this.windowSizeIncrement & Integer.MAX_VALUE);
        buffer.trim();
        return buffer;
    }

    public static class WindowUpdateFrameBuilder
    extends Http2Frame.Http2FrameBuilder<WindowUpdateFrameBuilder> {
        private int windowSizeIncrement;

        protected WindowUpdateFrameBuilder() {
        }

        public WindowUpdateFrameBuilder windowSizeIncrement(int windowSizeIncrement) {
            this.windowSizeIncrement = windowSizeIncrement;
            return this;
        }

        @Override
        public WindowUpdateFrame build() {
            WindowUpdateFrame frame = WindowUpdateFrame.create();
            this.setHeaderValuesTo(frame);
            frame.windowSizeIncrement = this.windowSizeIncrement;
            return frame;
        }

        @Override
        protected WindowUpdateFrameBuilder getThis() {
            return this;
        }
    }
}

