/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class PushPromiseFrame
extends HeaderBlockHead {
    private static final ThreadCache.CachedTypeIndex<PushPromiseFrame> CACHE_IDX = ThreadCache.obtainIndex(PushPromiseFrame.class, 8);
    public static final int TYPE = 5;
    private int promisedStreamId;

    private PushPromiseFrame() {
    }

    public static PushPromiseFrame fromBuffer(int length, int flags, int streamId, Buffer buffer) {
        PushPromiseFrame frame = PushPromiseFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        if (frame.isFlagSet(8)) {
            frame.padLength = buffer.get() & 0xFF;
        }
        frame.promisedStreamId = buffer.getInt() & Integer.MAX_VALUE;
        frame.compressedHeaders = buffer.split(buffer.position());
        frame.setFrameBuffer(buffer);
        return frame;
    }

    static PushPromiseFrame create() {
        PushPromiseFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new PushPromiseFrame();
        }
        return frame;
    }

    public static PushPromiseFrameBuilder builder() {
        return new PushPromiseFrameBuilder();
    }

    public PushPromiseFrame normalize() {
        if (this.isPadded()) {
            this.clearFlag(8);
            this.compressedHeaders.limit(this.compressedHeaders.limit() - this.padLength);
            this.padLength = 0;
            this.onPayloadUpdated();
        }
        return this;
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.padLength = 0;
        this.promisedStreamId = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        boolean isPadded = this.isFlagSet(8);
        MemoryManager memoryManager = http2Connection.getMemoryManager();
        Object buffer = memoryManager.allocate(http2Connection.getFrameHeaderSize() + (isPadded ? 1 : 0) + 4);
        http2Connection.serializeHttp2FrameHeader(this, (Buffer)buffer);
        if (isPadded) {
            buffer.put((byte)(this.padLength & 0xFF));
        }
        buffer.putInt(this.promisedStreamId);
        buffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer(memoryManager, new Buffer[]{buffer, this.compressedHeaders});
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PushPromiseFrame {").append(this.headerToString()).append(", promisedStreamId=").append(this.promisedStreamId).append(", padLength=").append(this.padLength).append(", compressedHeaders=").append(this.compressedHeaders).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        boolean isPadded = this.isFlagSet(8);
        return (isPadded ? 1 : 0) + 4 + (this.compressedHeaders != null ? this.compressedHeaders.remaining() : 0);
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return FLAG_NAMES_MAP;
    }

    public static class PushPromiseFrameBuilder
    extends HeaderBlockHead.HeaderBlockHeadBuilder<PushPromiseFrameBuilder> {
        private int promisedStreamId;

        protected PushPromiseFrameBuilder() {
        }

        public PushPromiseFrameBuilder promisedStreamId(int promisedStreamId) {
            this.promisedStreamId = promisedStreamId;
            return this;
        }

        @Override
        public PushPromiseFrame build() {
            PushPromiseFrame frame = PushPromiseFrame.create();
            this.setHeaderValuesTo(frame);
            frame.compressedHeaders = this.compressedHeaders;
            frame.padLength = this.padLength;
            frame.promisedStreamId = this.promisedStreamId;
            return frame;
        }

        @Override
        protected PushPromiseFrameBuilder getThis() {
            return this;
        }
    }
}

