/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.InvalidCharacterException;
import org.glassfish.grizzly.http2.hpack.DecodingCallback;

class DecoderUtils {
    private static final Logger LOGGER = Grizzly.logger(DecoderUtils.class);
    private static final String INVALID_CHARACTER_MESSAGE = "Invalid character 0x%02x at index '%s' found in header %s [%s: %s]";

    DecoderUtils() {
    }

    static void decodeRequestHeaders(Http2Connection http2Connection, final HttpRequestPacket request) throws InvalidCharacterException, IOException {
        try {
            http2Connection.getHeadersDecoder().decode(new DecodingCallback(){

                @Override
                public void onDecoded(CharSequence name, CharSequence value) {
                    DecoderUtils.validateHeaderCharacters(name, value);
                    if (name.charAt(0) == ':') {
                        DecoderUtils.processServiceRequestHeader(request, name.toString(), value.toString());
                    } else {
                        DecoderUtils.processNormalHeader(request, name.toString(), value.toString());
                    }
                }
            });
        }
        catch (RuntimeException re) {
            throw new InvalidCharacterException(re);
        }
        finally {
            request.setProtocol(Protocol.HTTP_2_0);
        }
    }

    static void decodeResponseHeaders(Http2Connection http2Connection, final HttpResponsePacket response) throws InvalidCharacterException, IOException {
        try {
            http2Connection.getHeadersDecoder().decode(new DecodingCallback(){

                @Override
                public void onDecoded(CharSequence name, CharSequence value) {
                    DecoderUtils.validateHeaderCharacters(name, value);
                    if (name.charAt(0) == ':') {
                        DecoderUtils.processServiceResponseHeader(response, name.toString(), value.toString());
                    } else {
                        DecoderUtils.processNormalHeader(response, name.toString(), value.toString());
                    }
                }
            });
        }
        catch (RuntimeException re) {
            throw new InvalidCharacterException(re);
        }
        finally {
            response.setProtocol(Protocol.HTTP_2_0);
        }
    }

    private static void processServiceRequestHeader(HttpRequestPacket request, String name, String value) {
        int valueLen = value.length();
        switch (name) {
            case ":path": {
                int questionIdx = value.indexOf(63);
                if (questionIdx == -1) {
                    request.getRequestURIRef().init(value);
                } else {
                    request.getRequestURIRef().init(value.substring(0, questionIdx));
                    if (questionIdx < valueLen - 1) {
                        request.getQueryStringDC().setString(value.substring(questionIdx + 1));
                    }
                }
                return;
            }
            case ":method": {
                request.getMethodDC().setString(value);
                return;
            }
            case ":scheme": {
                request.setSecure(valueLen == 5);
                return;
            }
            case ":authority": {
                request.getHeaders().addValue(Header.Host).setString(value);
                return;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{name, value});
    }

    private static void processServiceResponseHeader(HttpResponsePacket response, String name, String value) {
        int valueLen = value.length();
        switch (name) {
            case ":status": {
                if (valueLen != 3) {
                    throw new IllegalStateException("Unexpected status code: " + value);
                }
                response.setStatus(Integer.parseInt(value));
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{name, value});
    }

    private static void processNormalHeader(HttpHeader httpHeader, String name, String value) {
        MimeHeaders mimeHeaders = httpHeader.getHeaders();
        DataChunk valueChunk = mimeHeaders.addValue(name);
        valueChunk.setString(value.replace('\u0000', ','));
        DecoderUtils.finalizeKnownHeader(httpHeader, name, value);
    }

    private static void finalizeKnownHeader(HttpHeader httpHeader, String name, String value) {
        switch (name) {
            case "content-length": {
                httpHeader.setContentLengthLong(Long.parseLong(value));
                return;
            }
            case "upgrade": {
                httpHeader.getUpgradeDC().setString(value);
                return;
            }
            case "expect": {
                ((Http2Request)httpHeader).requiresAcknowledgement(true);
            }
        }
    }

    private static void validateHeaderCharacters(CharSequence name, CharSequence value) {
        assert (name != null);
        assert (value != null);
        int idx = DecoderUtils.ensureRange(name);
        if (idx != -1) {
            String msg = String.format(INVALID_CHARACTER_MESSAGE, name.charAt(idx), idx, "name", name, value);
            throw new RuntimeException(msg);
        }
        idx = DecoderUtils.ensureRange(value);
        if (idx != -1) {
            String msg = String.format(INVALID_CHARACTER_MESSAGE, name.charAt(idx), idx, "value", name, value);
            throw new RuntimeException(msg);
        }
    }

    private static int ensureRange(CharSequence cs) {
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            if (c >= ' ' && c <= '\u00ff') continue;
            return i;
        }
        return -1;
    }
}

