/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.flashlight.cli.MonitoringConfig;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="disable-monitoring")
@PerLookup
@I18n(value="disable.monitoring")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="disable-monitoring", description="disable-monitoring")})
public class DisableMonitoring
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private MonitoringService ms;
    @Inject
    private Target targetService;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(optional=true)
    private String modules;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableMonitoring.class);
    @AccessRequired.To(value={"update"})
    private Config targetConfig = null;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.targetConfig = this.targetService.getConfig(this.target);
            if (this.targetConfig != null) {
                this.ms = this.targetConfig.getMonitoringService();
                return true;
            }
            this.fail(report, "unknown.target", "Could not find target {0}", this.target);
            return false;
        }
        catch (Exception e) {
            this.fail(report, "target.service.exception", "Encountered exception trying to locate the MonitoringService element in the target ({0}) configuration: {1}", this.target, e.getMessage());
            return false;
        }
    }

    private void fail(ActionReport report, String messageKey, String fallbackMessageText, Object ... args) {
        report.setMessage(this.localStrings.getLocalString(messageKey, fallbackMessageText, args));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.modules == null || this.modules.length() < 1) {
                boolean enabled = Boolean.parseBoolean(this.ms.getMonitoringEnabled());
                if (enabled) {
                    MonitoringConfig.setMonitoringEnabled(this.ms, "false", report);
                } else {
                    report.setMessage(this.localStrings.getLocalString("disable.monitoring.alreadyfalse", "monitoring-enabled is already set to false"));
                }
            } else {
                String[] strArr;
                for (String moduleName : strArr = this.modules.split(":")) {
                    if (moduleName.length() <= 0) continue;
                    MonitoringConfig.setMonitoringLevel(this.ms, moduleName, "OFF", report);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("disable.monitoring.exception", "Encountered exception during disabling monitoring {0}", e.getMessage()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

