/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.glassfish.ejb.embedded.DeploymentElement;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.archive.ScatteredArchive;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class EJBContainerImpl
extends EJBContainer {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, "javax.enterprise.system.container.ejb");
    private final GlassFish server;
    private final Deployer deployer;
    private String deployedAppName;
    private ServiceLocator habitat;
    private volatile int state = 0;
    private Cleanup cleanup = null;
    private DeploymentElement.ResultApplication res_app;
    private static final int STARTING = 0;
    private static final int RUNNING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;

    EJBContainerImpl(GlassFish server) throws GlassFishException {
        this.server = server;
        this.server.start();
        this.habitat = server.getService(ServiceLocator.class);
        this.deployer = server.getDeployer();
        this.state = 1;
        this.cleanup = new Cleanup(this);
    }

    void deploy(Map<?, ?> properties, Set<DeploymentElement> modules) throws EJBException {
        try {
            String appName = properties == null ? null : (String)properties.get("javax.ejb.embeddable.appName");
            this.res_app = DeploymentElement.getOrCreateApplication(modules, appName);
            Object app = this.res_app.getApplication();
            if (app == null) {
                throw new EJBException("Invalid set of modules to deploy - see log for details");
            }
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[EJBContainerImpl] Deploying app: " + app);
            }
            String[] params = (appName = this.res_app.getAppName()) != null ? new String[]{"--name", appName} : new String[]{};
            _logger.info("[EJBContainerImpl] GlassFish status: " + (Object)((Object)this.server.getStatus()));
            if (app instanceof ScatteredArchive) {
                _logger.info("[EJBContainerImpl] Deploying as a ScatteredArchive");
                this.deployedAppName = this.deployer.deploy(((ScatteredArchive)app).toURI(), params);
            } else {
                _logger.info("[EJBContainerImpl] Deploying as a File");
                this.deployedAppName = this.deployer.deploy((File)app, params);
            }
        }
        catch (Exception e) {
            throw new EJBException("Failed to deploy EJB modules", e);
        }
        if (this.deployedAppName == null) {
            throw new EJBException("Failed to deploy EJB modules - see log for details");
        }
    }

    @Override
    public Context getContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN getContext()");
        }
        try {
            return new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.cannot_create_context"), e);
        }
    }

    @Override
    public void close() {
        if (this.cleanup != null) {
            this.cleanup.disable();
        }
        if (this.isOpen()) {
            this.forceClose();
        }
    }

    void forceClose() {
        this.state = 2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN close()");
        }
        this.undeploy();
        this.cleanupTransactions();
        this.cleanupConnectorRuntime();
        if (this.res_app != null && this.res_app.deleteOnExit()) {
            try {
                FileUtils.whack((File)this.res_app.getApplication());
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error in removing temp file", e);
            }
        }
        this.stop();
    }

    boolean isOpen() {
        return this.state == 1;
    }

    private void cleanupTransactions() {
        try {
            TransactionManager txmgr;
            ServiceHandle<TransactionManager> inhabitant = this.habitat.getServiceHandle(TransactionManager.class, new Annotation[0]);
            if (inhabitant != null && inhabitant.isActive() && (txmgr = inhabitant.getService()).getTransaction() != null) {
                txmgr.rollback();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupTransactions", t);
        }
    }

    private void cleanupConnectorRuntime() {
        try {
            ServiceHandle<ConnectorRuntime> inhabitant = this.habitat.getServiceHandle(ConnectorRuntime.class, new Annotation[0]);
            if (inhabitant != null && inhabitant.isActive()) {
                ConnectorRuntime connectorRuntime = inhabitant.getService();
                connectorRuntime.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupConnectorRuntime", t);
        }
    }

    private void undeploy() {
        if (this.deployedAppName != null) {
            try {
                this.deployer.undeploy(this.deployedAppName, new String[0]);
            }
            catch (Exception e) {
                _logger.warning("Cannot undeploy deployed modules: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.state == 3) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (GlassFishException e) {
            _logger.log(Level.WARNING, "Cannot stop embedded server", e);
        }
        finally {
            try {
                this.server.dispose();
            }
            catch (GlassFishException e) {
                _logger.log(Level.WARNING, "Cannot dispose embedded server", e);
            }
            this.state = 3;
        }
    }

    private static class Cleanup
    implements Runnable {
        private Thread cleanupThread = null;
        private EJBContainerImpl container = null;

        Cleanup(EJBContainerImpl container) {
            this.container = container;
            this.cleanupThread = new Thread((Runnable)this, "EJBContainerImplCleanup");
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        }

        void disable() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime.getRuntime().removeShutdownHook(Cleanup.this.cleanupThread);
                    return null;
                }
            });
        }

        @Override
        public void run() {
            if (this.container.isOpen()) {
                this.container.forceClose();
            }
        }
    }
}

