/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbCMPFinder;
import org.glassfish.ejb.deployment.descriptor.runtime.PrefetchDisabledDescriptor;
import org.glassfish.ejb.deployment.node.runtime.FinderNode;
import org.glassfish.ejb.deployment.node.runtime.PrefetchDisabledNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CmpNode
extends DeploymentDescriptorNode<IASEjbCMPEntityDescriptor> {
    protected IASEjbCMPEntityDescriptor descriptor;

    public CmpNode() {
        this.registerElementHandler(new XMLElement("finder"), FinderNode.class);
        this.registerElementHandler(new XMLElement("prefetch-disabled"), PrefetchDisabledNode.class);
    }

    @Override
    public IASEjbCMPEntityDescriptor getDescriptor() {
        Object desc;
        if (this.descriptor == null && (desc = this.getParentNode().getDescriptor()) instanceof IASEjbCMPEntityDescriptor) {
            this.descriptor = (IASEjbCMPEntityDescriptor)desc;
        }
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> dispatchTable = super.getDispatchTable();
        dispatchTable.put("mapping-properties", "setMappingProperties");
        dispatchTable.put("is-one-one-cmp", null);
        return dispatchTable;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        this.getDescriptor();
        if (this.descriptor == null) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{newDescriptor, this});
            return;
        }
        if (newDescriptor instanceof IASEjbCMPFinder) {
            this.descriptor.addOneOneFinder((IASEjbCMPFinder)newDescriptor);
        } else if (newDescriptor instanceof PrefetchDisabledDescriptor) {
            this.descriptor.setPrefetchDisabledDescriptor((PrefetchDisabledDescriptor)newDescriptor);
        } else {
            super.addDescriptor(this.descriptor);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, IASEjbCMPEntityDescriptor ejbDescriptor) {
        PrefetchDisabledDescriptor prefetchDisabledDesc;
        Node cmpNode = super.writeDescriptor(parent, nodeName, ejbDescriptor);
        CmpNode.appendTextChild(cmpNode, "mapping-properties", ejbDescriptor.getMappingProperties());
        Map finders = ejbDescriptor.getOneOneFinders();
        if (!finders.isEmpty()) {
            Element findersNode = CmpNode.appendChild(cmpNode, "one-one-finders");
            FinderNode fn = new FinderNode();
            for (IASEjbCMPFinder aFinder : finders.values()) {
                fn.writeDescriptor((Node)findersNode, "finder", aFinder);
            }
        }
        if ((prefetchDisabledDesc = ejbDescriptor.getPrefetchDisabledDescriptor()) != null) {
            PrefetchDisabledNode prefetchDisabledNode = new PrefetchDisabledNode();
            prefetchDisabledNode.writeDescriptor(cmpNode, "prefetch-disabled", prefetchDisabledDesc);
        }
        return cmpNode;
    }
}

