/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import fish.payara.concurrent.monitoring.ManagedScheduledExecutorServiceStatsProvider;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ManagedScheduledExecutorService.class)
@Singleton
public class ManagedScheduledExecutorServiceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    @Inject
    ConcurrentRuntime concurrentRuntime;
    private ManagedScheduledExecutorServiceStatsProvider managedScheduledExecutorServiceProbeListener;
    private static Logger _logger = LogFacade.getLogger();

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ManagedScheduledExecutorService managedScheduledExecutorServiceRes = (ManagedScheduledExecutorService)resource;
        if (managedScheduledExecutorServiceRes == null) {
            _logger.log(Level.WARNING, "AS-CONCURRENT-00004", "ManagedScheduledExecutorService");
            return;
        }
        String jndiName = managedScheduledExecutorServiceRes.getJndiName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ManagedScheduledExecutorServiceDeployer.deployResource() : jndi-name [" + jndiName + "]");
        }
        ResourceInfo resourceInfo = new ResourceInfo(managedScheduledExecutorServiceRes.getJndiName(), applicationName, moduleName);
        ManagedScheduledExecutorServiceConfig config = new ManagedScheduledExecutorServiceConfig(managedScheduledExecutorServiceRes);
        Reference ref = new Reference(javax.enterprise.concurrent.ManagedScheduledExecutorService.class.getName(), "org.glassfish.concurrent.runtime.deployer.ConcurrentObjectFactory", null);
        SerializableObjectRefAddr addr = new SerializableObjectRefAddr(ManagedScheduledExecutorServiceConfig.class.getName(), config);
        ref.add(addr);
        SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), resourceInfo);
        ref.add(resAddr);
        try {
            this.namingService.publishObject(resourceInfo, ref, true);
        }
        catch (NamingException ex) {
            LogHelper.log(_logger, Level.SEVERE, "AS-CONCURRENT-00003", ex, "ManagedScheduledExecutorService", jndiName);
        }
        this.registerMonitorableComponent(managedScheduledExecutorServiceRes);
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        ManagedScheduledExecutorService ManagedScheduledExecutorServiceResource = (ManagedScheduledExecutorService)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(ManagedScheduledExecutorServiceResource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        ManagedScheduledExecutorService ManagedScheduledExecutorServiceResource = (ManagedScheduledExecutorService)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(ManagedScheduledExecutorServiceResource);
        this.undeployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ManagedScheduledExecutorService managedscheduledexecutorserviceRes = (ManagedScheduledExecutorService)resource;
        ResourceInfo resourceInfo = new ResourceInfo(managedscheduledexecutorserviceRes.getJndiName(), applicationName, moduleName);
        this.namingService.unpublishObject(resourceInfo, managedscheduledexecutorserviceRes.getJndiName());
        this.concurrentRuntime.shutdownScheduledManagedExecutorService(managedscheduledexecutorserviceRes.getJndiName());
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ManagedScheduledExecutorService;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private void registerMonitorableComponent(ManagedScheduledExecutorService managedScheduledExecutorService) {
        this.managedScheduledExecutorServiceProbeListener = new ManagedScheduledExecutorServiceStatsProvider(managedScheduledExecutorService);
        this.managedScheduledExecutorServiceProbeListener.register();
    }

    private void unregisterMonitableComponent() {
        this.managedScheduledExecutorServiceProbeListener.unregister();
    }
}

