/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.concurrent.ContextService;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.InvocationContext;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;

public class ContextSetupProviderImpl
implements ContextSetupProvider {
    private transient InvocationManager invocationManager;
    private transient Deployment deployment;
    private transient Applications applications;
    private transient JavaEETransactionManager transactionManager;
    private static final Logger logger = LogFacade.getLogger();
    static final long serialVersionUID = -1095988075917755802L;
    private boolean classloading;
    private boolean security;
    private boolean naming;
    private boolean workArea;
    private RequestTracingService requestTracing;

    public ContextSetupProviderImpl(InvocationManager invocationManager, Deployment deployment, Applications applications, JavaEETransactionManager transactionManager, CONTEXT_TYPE ... contextTypes) {
        this.invocationManager = invocationManager;
        this.deployment = deployment;
        this.applications = applications;
        this.transactionManager = transactionManager;
        try {
            this.requestTracing = Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Request Tracing service during initialisation of Concurrent Context - NullPointerException");
        }
        block8: for (CONTEXT_TYPE contextType : contextTypes) {
            switch (contextType) {
                case CLASSLOADING: {
                    this.classloading = true;
                    continue block8;
                }
                case SECURITY: {
                    this.security = true;
                    continue block8;
                }
                case NAMING: {
                    this.naming = true;
                    continue block8;
                }
                case WORKAREA: {
                    this.workArea = true;
                }
            }
        }
    }

    @Override
    public ContextHandle saveContext(ContextService contextService) {
        return this.saveContext(contextService, null);
    }

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        Object currentInvocation;
        ClassLoader contextClassloader = null;
        SecurityContext currentSecurityContext = null;
        ComponentInvocation savedInvocation = null;
        if (this.classloading) {
            contextClassloader = Utility.getClassLoader();
        }
        if (this.security) {
            currentSecurityContext = SecurityContext.getCurrent();
        }
        if ((currentInvocation = this.invocationManager.getCurrentInvocation()) != null) {
            savedInvocation = this.createComponentInvocation((ComponentInvocation)currentInvocation);
        }
        boolean useTransactionOfExecutionThread = this.transactionManager == null && this.useTransactionOfExecutionThread(contextObjectProperties);
        return new InvocationContext(savedInvocation, contextClassloader, currentSecurityContext, useTransactionOfExecutionThread);
    }

    @Override
    public ContextHandle setup(ContextHandle contextHandle) throws IllegalStateException {
        ComponentInvocation invocation;
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return null;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        String appName = null;
        if (handle.getInvocation() != null) {
            appName = handle.getInvocation().getAppName();
        }
        if (!this.isApplicationEnabled(appName)) {
            throw new IllegalStateException("Module " + appName + " is disabled");
        }
        ClassLoader resetClassLoader = null;
        SecurityContext resetSecurityContext = null;
        if (handle.getContextClassLoader() != null) {
            resetClassLoader = Utility.setContextClassLoader(handle.getContextClassLoader());
        }
        if (handle.getSecurityContext() != null) {
            resetSecurityContext = SecurityContext.getCurrent();
            SecurityContext.setCurrent(handle.getSecurityContext());
        }
        if ((invocation = handle.getInvocation()) != null && !handle.isUseTransactionOfExecutionThread()) {
            invocation.setResourceTableKey(new PairKey(invocation.getInstance(), Thread.currentThread()));
            this.invocationManager.preInvoke(invocation);
        }
        if (this.transactionManager != null) {
            this.transactionManager.clearThreadTx();
        }
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
            RequestEvent requestEvent = this.constructConcurrentContextEvent(invocation);
            this.requestTracing.traceRequestEvent(requestEvent);
        }
        return new InvocationContext(invocation, resetClassLoader, resetSecurityContext, handle.isUseTransactionOfExecutionThread());
    }

    private RequestEvent constructConcurrentContextEvent(ComponentInvocation invocation) {
        this.requestTracing.startTrace();
        RequestEvent requestEvent = new RequestEvent("ConcurrentContextTrace");
        requestEvent.addProperty("App Name", invocation.getAppName());
        requestEvent.addProperty("Component ID", invocation.getComponentId());
        requestEvent.addProperty("Module Name", invocation.getModuleName());
        requestEvent.addProperty("Class Name", invocation.getInstance().getClass().getName());
        requestEvent.addProperty("Thread Name", Thread.currentThread().getName());
        return requestEvent;
    }

    @Override
    public void reset(ContextHandle contextHandle) {
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        if (handle.getContextClassLoader() != null) {
            Utility.setContextClassLoader(handle.getContextClassLoader());
        }
        if (handle.getSecurityContext() != null) {
            SecurityContext.setCurrent(handle.getSecurityContext());
        }
        if (handle.getInvocation() != null && !handle.isUseTransactionOfExecutionThread()) {
            this.invocationManager.postInvoke(((InvocationContext)contextHandle).getInvocation());
        }
        if (this.transactionManager != null) {
            JavaEETransaction transaction = this.transactionManager.getCurrentTransaction();
            if (transaction != null) {
                try {
                    int status = transaction.getStatus();
                    if (status == 0) {
                        this.transactionManager.commit();
                    } else if (status == 1) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.toString());
                }
            }
            this.transactionManager.clearThreadTx();
        }
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
            this.requestTracing.endTrace();
        }
    }

    private boolean isApplicationEnabled(String appId) {
        boolean result = false;
        if (appId != null) {
            Application app = this.applications.getApplication(appId);
            if (app != null) {
                result = this.deployment.isAppEnabled(app);
            } else {
                logger.info("Job submitted for " + appId + " likely during deployment. Continuing...");
                result = true;
            }
        }
        return result;
    }

    private ComponentInvocation createComponentInvocation(ComponentInvocation currInv) {
        ComponentInvocation newInv = currInv.clone();
        newInv.setResourceTableKey(null);
        newInv.instance = currInv.getInstance();
        if (!this.naming) {
            newInv.setJNDIEnvironment(null);
        }
        return newInv;
    }

    private boolean useTransactionOfExecutionThread(Map<String, String> executionProperties) {
        return "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(this.getTransactionExecutionProperty(executionProperties));
    }

    private String getTransactionExecutionProperty(Map<String, String> executionProperties) {
        if (executionProperties != null && executionProperties.get("javax.enterprise.concurrent.TRANSACTION") != null) {
            return executionProperties.get("javax.enterprise.concurrent.TRANSACTION");
        }
        return "SUSPEND";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.transactionManager == null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean nullTransactionManager = in.readBoolean();
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.invocationManager = concurrentRuntime.getInvocationManager();
        this.deployment = concurrentRuntime.getDeployment();
        this.applications = concurrentRuntime.getApplications();
        if (!nullTransactionManager) {
            this.transactionManager = concurrentRuntime.getTransactionManager();
        }
    }

    private static class PairKey {
        private Object instance = null;
        private Thread thread = null;
        int hCode = 0;

        private PairKey(Object inst, Thread thr) {
            this.instance = inst;
            this.thread = thr;
            if (inst != null) {
                this.hCode = 7 * inst.hashCode();
            }
            if (thr != null) {
                this.hCode += thr.hashCode();
            }
        }

        public int hashCode() {
            return this.hCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            boolean eq = false;
            if (obj != null && obj instanceof PairKey) {
                PairKey p = (PairKey)obj;
                if (this.instance != null) {
                    eq = this.instance.equals(p.instance);
                } else {
                    boolean bl = eq = p.instance == null;
                }
                if (eq) {
                    eq = this.thread != null ? this.thread.equals(p.thread) : p.thread == null;
                }
            }
            return eq;
        }
    }

    static enum CONTEXT_TYPE {
        CLASSLOADING,
        SECURITY,
        NAMING,
        WORKAREA;

    }
}

