/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.DefaultResourceProxy;
import org.glassfish.concurrent.config.ContextService;
import org.glassfish.concurrent.runtime.deployer.DefaultContextService;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-context-services")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.context.services")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-context-services", description="List Context Services")})
public class ListContextServices
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListContextServices.class);
    @Param(primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    private Domain domain;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private DefaultContextService defaultService;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Collection<ContextService> contextServices = this.domain.getResources().getResources(ContextService.class);
            ArrayList resourcesList = new ArrayList();
            List<DefaultResourceProxy> drps = this.habitat.getAllServices(DefaultResourceProxy.class, new Annotation[0]);
            for (ContextService contextService : contextServices) {
                String jndiName = contextService.getJndiName();
                if (!this.bindableResourcesHelper.resourceExists(jndiName, this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
                HashMap<String, String> resourceNameMap = new HashMap<String, String>();
                String logicalName = DefaultResourceProxy.Util.getLogicalName(drps, jndiName);
                if (logicalName != null) {
                    resourceNameMap.put("logical-jndi-name", logicalName);
                }
                resourceNameMap.put("name", jndiName);
                resourcesList.add(resourceNameMap);
            }
            Properties extraProperties = new Properties();
            extraProperties.put("contextServices", resourcesList);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.context.service.failed", "List context services failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

