/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.glassfish.cdi.hk2.DefaultImpl;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class HK2CDIBean<T>
implements Bean<T> {
    private final ServiceLocator locator;
    private final ActiveDescriptor<T> descriptor;

    HK2CDIBean(ServiceLocator serviceLocator, ActiveDescriptor<T> descriptor) {
        this.locator = serviceLocator;
        this.descriptor = descriptor;
    }

    @Override
    public T create(CreationalContext<T> arg0) {
        ServiceHandle<T> serviceHandle = this.locator.getServiceHandle(this.descriptor);
        return serviceHandle.getService();
    }

    @Override
    public void destroy(T arg0, CreationalContext<T> arg1) {
        this.descriptor.dispose(arg0);
    }

    @Override
    public Class<?> getBeanClass() {
        return this.descriptor.getImplementationClass();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        if (this.descriptor.getQualifierAnnotations().isEmpty()) {
            HashSet<Annotation> retVal = new HashSet<Annotation>();
            retVal.add(new DefaultImpl());
            return retVal;
        }
        return this.descriptor.getQualifierAnnotations();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        Class<Annotation> scope = this.descriptor.getScopeAnnotation();
        if (scope == null || scope.equals(PerLookup.class)) {
            scope = Dependent.class;
        }
        return scope;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Type> getTypes() {
        return this.descriptor.getContractTypes();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public ActiveDescriptor<T> getHK2Descriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "HK2CDIBean(" + this.descriptor + "," + System.identityHashCode(this) + ")";
    }
}

