/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.optional;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public class ForeignDBViews
implements OptionalTool {
    private static final int XML_TYPE = 2009;
    private static final String[] SAFE_DROP_SQLSTATES = new String[]{"X0X05.S", "42Y55", "42Y07"};

    @Override
    public void loadTool(String ... stringArray) throws SQLException {
        if (stringArray == null || stringArray.length < 1) {
            throw this.wrap(LocalizedResource.getMessage("OT_BadLoadUnloadArgs"));
        }
        String string = stringArray[0];
        String string2 = stringArray.length == 1 ? null : stringArray[1];
        Connection connection = this.getForeignConnection(string);
        Connection connection2 = this.getDerbyConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = this.getForeignTables(databaseMetaData);
        while (resultSet.next()) {
            this.registerForeignTable(databaseMetaData, resultSet.getString(2), resultSet.getString(3), string, string2, connection2);
        }
        resultSet.close();
        connection.close();
    }

    @Override
    public void unloadTool(String ... stringArray) throws SQLException {
        if (stringArray == null || stringArray.length < 1) {
            throw this.wrap(LocalizedResource.getMessage("OT_BadLoadUnloadArgs"));
        }
        String string = stringArray[0];
        String string2 = stringArray.length == 1 ? null : stringArray[1];
        Connection connection = this.getForeignConnection(string);
        Connection connection2 = this.getDerbyConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = this.getForeignTables(databaseMetaData);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (resultSet.next()) {
            String string3 = this.getDerbySchemaName(string2, resultSet.getString(2));
            String string4 = resultSet.getString(3);
            if (string3 != null) {
                hashSet.add(string3);
            }
            this.dropObject(connection2, string3, string4, "view", false);
            this.dropObject(connection2, string3, string4, "function", false);
        }
        resultSet.close();
        connection.close();
        for (String string3 : hashSet) {
            this.dropDerbySchema(connection2, string3);
        }
    }

    private void registerForeignTable(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String string4, Connection connection) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = this.getDerbySchemaName(string4, string);
        String string6 = this.dotSeparatedSchemaName(string5);
        this.createDerbySchema(connection, string5);
        stringBuilder.append("create function " + string6 + this.delimitedID(string2));
        stringBuilder.append("\n(");
        stringBuilder.append("\n\tforeignSchemaName varchar( 32672 ),");
        stringBuilder.append("\n\tforeignTableName varchar( 32672 ),");
        stringBuilder.append("\n\tconnectionURL varchar( 32672 )");
        stringBuilder.append("\n)\nreturns table\n(");
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, "%");
        int n = 0;
        while (resultSet.next()) {
            stringBuilder.append("\n\t");
            if (n > 0) {
                stringBuilder.append(", ");
            }
            ++n;
            stringBuilder.append(this.delimitedID(resultSet.getString(4)));
            stringBuilder.append(" ");
            stringBuilder.append(this.mapType(resultSet.getInt(5), resultSet.getInt(7), resultSet.getInt(9), resultSet.getString(6)));
        }
        resultSet.close();
        stringBuilder.append("\n)");
        stringBuilder.append("\nlanguage java parameter style derby_jdbc_result_set no sql");
        stringBuilder.append("\nexternal name 'org.apache.derby.vti.ForeignTableVTI.readForeignTable'");
        String string7 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("create view " + string6 + this.delimitedID(string2));
        stringBuilder2.append("\nas select *");
        stringBuilder2.append("\nfrom table");
        stringBuilder2.append("\n(\n");
        stringBuilder2.append("\t" + string6 + this.delimitedID(string2));
        stringBuilder2.append("\n\t(");
        stringBuilder2.append("\n\t\t" + this.stringLiteral(string) + ",");
        stringBuilder2.append("\n\t\t" + this.stringLiteral(string2) + ",");
        stringBuilder2.append("\n\t\t" + this.stringLiteral(string3));
        stringBuilder2.append("\n\t)");
        stringBuilder2.append("\n) s");
        String string8 = stringBuilder2.toString();
        this.executeDDL(connection, string7);
        this.executeDDL(connection, string8);
    }

    private ResultSet getForeignTables(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getTables(null, null, "%", new String[]{"TABLE"});
    }

    private void createDerbySchema(Connection connection, String string) throws SQLException {
        if (string == null) {
            return;
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, "select count(*) from sys.sysschemas where schemaname = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            this.executeDDL(connection, "create schema " + this.delimitedID(string));
        }
    }

    private void dropDerbySchema(Connection connection, String string) throws SQLException {
        if (string == null) {
            return;
        }
        this.dropObject(connection, null, string, "schema", true);
    }

    private String getDerbySchemaName(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        return string + string2;
    }

    private String dotSeparatedSchemaName(String string) {
        if (string == null) {
            return "";
        }
        return this.delimitedID(string) + ".";
    }

    private String mapType(int n, int n2, int n3, String string) throws SQLException {
        switch (n) {
            case -5: {
                return "bigint";
            }
            case -2: {
                return "char " + this.precisionToLength(n2) + "  for bit data";
            }
            case -7: {
                return "boolean";
            }
            case 2004: {
                return "blob";
            }
            case 16: {
                return "boolean";
            }
            case 1: {
                return "char" + this.precisionToLength(n2);
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal" + this.precisionAndScale(n2, n3);
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case -4: {
                return "long varchar for bit data";
            }
            case -1: {
                return "long varchar";
            }
            case 2: {
                return "numeric" + this.precisionAndScale(n2, n3);
            }
            case 7: {
                return "real";
            }
            case 5: {
                return "smallint";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "smallint";
            }
            case -3: {
                return "varchar " + this.precisionToLength(n2) + "  for bit data";
            }
            case 12: {
                return "varchar" + this.precisionToLength(n2);
            }
            case 2009: {
                return "xml";
            }
        }
        throw this.wrap(LocalizedResource.getMessage("OT_UnknownForeignDataType", Integer.toString(n), string));
    }

    private String precisionToLength(int n) {
        return "( " + n + " )";
    }

    private String precisionAndScale(int n, int n2) {
        return "( " + n + ", " + n2 + " )";
    }

    private void dropObject(Connection connection, String string, String string2, String string3, boolean bl) throws SQLException {
        String string4 = this.dotSeparatedSchemaName(string);
        String string5 = bl ? " restrict" : "";
        try {
            this.executeDDL(connection, "drop " + string3 + " " + string4 + this.delimitedID(string2) + string5);
        }
        catch (SQLException sQLException) {
            String string6 = sQLException.getSQLState();
            for (String string7 : SAFE_DROP_SQLSTATES) {
                if (!string6.startsWith(string7)) continue;
                return;
            }
            throw sQLException;
        }
    }

    private Connection getForeignConnection(String string) throws SQLException {
        return DriverManager.getConnection(string);
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String delimitedID(String string) {
        return IdUtil.normalToDelimited(string);
    }

    private String stringLiteral(String string) {
        return StringUtil.quoteStringLiteral(string);
    }

    private void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }
}

