/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.notification.configuration.Notifier;
import fish.payara.nucleus.notification.service.BaseNotifierService;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptions;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptionsFactory;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="requesttracing-configure-notifier")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="requesttracing.configure.notifier")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="requesttracing-configure-notifier", description="Enables/Disables Notifier Specified With Name")})
public class RequestTracingNotifierConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(RequestTracingNotifierConfigurer.class);
    @Inject
    ServerEnvironment server;
    @Inject
    RequestTracingService service;
    @Inject
    NotifierExecutionOptionsFactory factory;
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="notifierName", optional=true, defaultValue="service-log")
    private String notifierName;
    @Param(name="notifierEnabled", optional=false)
    private Boolean notifierEnabled;
    @Inject
    ServiceLocator serviceLocator;

    @Override
    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        AdminCommandContext theContext = context;
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        Config config = this.targetUtil.getConfig(this.target);
        final BaseNotifierService notifierService = this.habitat.getService(BaseNotifierService.class, this.notifierName, new Annotation[0]);
        if (this.service == null) {
            actionReport.appendMessage(strings.getLocalString("requesttracing.notifier.configure.status.error", "Notifier with name {0} could not be found.", this.notifierName));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        RequestTracingServiceConfiguration requestTracingServiceConfiguration = config.getExtensionByType(RequestTracingServiceConfiguration.class);
        Object notifier = requestTracingServiceConfiguration.getNotifierByType(notifierService.getNotifierType());
        try {
            if (notifier == null) {
                ConfigSupport.apply(new SingleConfigCode<RequestTracingServiceConfiguration>(){

                    @Override
                    public Object run(RequestTracingServiceConfiguration requestTracingServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        Notifier notifierProxy = (Notifier)requestTracingServiceConfigurationProxy.createChild(notifierService.getNotifierType());
                        if (RequestTracingNotifierConfigurer.this.notifierEnabled != null) {
                            notifierProxy.enabled(String.valueOf(RequestTracingNotifierConfigurer.this.notifierEnabled));
                        }
                        requestTracingServiceConfigurationProxy.getNotifierList().add(notifierProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return requestTracingServiceConfigurationProxy;
                    }
                }, requestTracingServiceConfiguration);
            } else {
                ConfigSupport.apply(new SingleConfigCode<Notifier>(){

                    @Override
                    public Object run(Notifier notifierProxy) throws PropertyVetoException, TransactionFailure {
                        if (RequestTracingNotifierConfigurer.this.notifierEnabled != null) {
                            notifierProxy.enabled(String.valueOf(RequestTracingNotifierConfigurer.this.notifierEnabled));
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return notifierProxy;
                    }
                }, notifier);
            }
            if (this.dynamic.booleanValue()) {
                Object dynamicNotifier = requestTracingServiceConfiguration.getNotifierByType(notifierService.getNotifierType());
                NotifierExecutionOptions build = this.factory.build((Notifier)dynamicNotifier);
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        if (this.notifierEnabled.booleanValue()) {
                            build.setEnabled(this.notifierEnabled);
                            this.service.getExecutionOptions().addNotifierExecutionOption(build);
                        } else {
                            this.service.getExecutionOptions().removeNotifierExecutionOption(build);
                        }
                    }
                } else if (this.notifierEnabled.booleanValue()) {
                    build.setEnabled(this.notifierEnabled);
                    this.service.getExecutionOptions().addNotifierExecutionOption(build);
                } else {
                    this.service.getExecutionOptions().removeNotifierExecutionOption(build);
                }
            }
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.notifier.added.configured", "Request Tracing Notifier with name {0} is registered and set enabled to {1}.", this.notifierName, this.notifierEnabled) + "\n");
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

