/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="requesttracing-configure")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="requesttracing.configure")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="requesttracing-configure", description="Enables/Disables Request Tracing Service")})
public class RequestTracingConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(RequestTracingConfigurer.class);
    @Inject
    ServerEnvironment server;
    @Inject
    RequestTracingService service;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="thresholdUnit", optional=true, defaultValue="SECONDS")
    private String unit;
    @Param(name="thresholdValue", optional=true, defaultValue="30")
    private String value;
    @Inject
    ServiceLocator serviceLocator;
    CommandRunner.CommandInvocation inv;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (!this.validate(actionReport)) {
            return;
        }
        Config config = this.targetUtil.getConfig(this.target);
        RequestTracingServiceConfiguration requestTracingServiceConfiguration = config.getExtensionByType(RequestTracingServiceConfiguration.class);
        if (requestTracingServiceConfiguration != null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<RequestTracingServiceConfiguration>(){

                    @Override
                    public Object run(RequestTracingServiceConfiguration requestTracingServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (RequestTracingConfigurer.this.enabled != null) {
                            requestTracingServiceConfigurationProxy.enabled(RequestTracingConfigurer.this.enabled.toString());
                        }
                        if (RequestTracingConfigurer.this.unit != null) {
                            requestTracingServiceConfigurationProxy.setThresholdUnit(RequestTracingConfigurer.this.unit);
                        }
                        if (RequestTracingConfigurer.this.value != null) {
                            requestTracingServiceConfigurationProxy.setThresholdValue(RequestTracingConfigurer.this.value);
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return requestTracingServiceConfigurationProxy;
                    }
                }, requestTracingServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            if (this.server.isDas()) {
                if (this.targetUtil.getConfig(this.target).isDas()) {
                    this.service.getExecutionOptions().setEnabled(this.enabled);
                    if (this.value != null) {
                        this.service.getExecutionOptions().setThresholdValue(Long.valueOf(this.value));
                        actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdvalue.success", "Request Tracing Service Threshold Value is set to {0}.", this.value) + "\n");
                    }
                    if (this.unit != null) {
                        this.service.getExecutionOptions().setThresholdUnit(TimeUnit.valueOf(this.unit));
                        actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdunit.success", "Request Tracing Service Threshold Unit is set to {0}.", this.unit) + "\n");
                    }
                }
            } else {
                this.service.getExecutionOptions().setEnabled(this.enabled);
                if (this.value != null) {
                    this.service.getExecutionOptions().setThresholdValue(Long.valueOf(this.value));
                    actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdvalue.success", "Request Tracing Service Threshold Value is set to {0}.", this.value) + "\n");
                }
                if (this.unit != null) {
                    this.service.getExecutionOptions().setThresholdUnit(TimeUnit.valueOf(this.unit));
                    actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdunit.success", "Request Tracing Service Threshold Unit is set to {0}.", this.unit) + "\n");
                }
            }
        }
    }

    private boolean validate(ActionReport actionReport) {
        boolean result = false;
        if (this.value != null) {
            try {
                int thresholdValue = Integer.parseInt(this.value);
                if (thresholdValue <= 0 || thresholdValue > 65534) {
                    actionReport.failure(this.logger, "Threshold Value must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "Threshold Value is not a valid integer", nfe);
                return result;
            }
        }
        if (this.unit != null) {
            try {
                if (!(this.unit.equals("NANOSECONDS") || this.unit.equals("MICROSECONDS") || this.unit.equals("MILLISECONDS") || this.unit.equals("SECONDS") || this.unit.equals("MINUTES") || this.unit.equals("HOURS") || this.unit.equals("DAYS"))) {
                    actionReport.failure(this.logger, this.unit + " is an invalid time unit");
                    return result;
                }
            }
            catch (IllegalArgumentException iaf) {
                actionReport.failure(this.logger, this.unit + " is an invalid time unit", iaf);
                return result;
            }
        }
        return true;
    }
}

