/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.notification.configuration.LogNotifier;
import fish.payara.nucleus.notification.service.BaseNotifierService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-requesttracing-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.requesttracing.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-requesttracing-configuration", description="List Request Tracing Configuration")})
public class GetRequestTracingConfiguration
implements AdminCommand {
    @Inject
    ServiceLocator habitat;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport mainActionReport = context.getActionReport();
        RequestTracingServiceConfiguration configuration = config.getExtensionByType(RequestTracingServiceConfiguration.class);
        List<ServiceHandle<BaseNotifierService>> allNotifierHandles = this.habitat.getAllServiceHandles(BaseNotifierService.class, new Annotation[0]);
        String[] headers = new String[]{"Enabled", "ThresholdUnit", "ThresholdValue", "Notifier Name", "Notifier Enabled"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Object[] values = new Object[5];
        values[0] = configuration.getEnabled();
        values[1] = configuration.getThresholdUnit();
        values[2] = configuration.getThresholdValue();
        for (ServiceHandle<BaseNotifierService> notifierHandle : allNotifierHandles) {
            Object notifier = configuration.getNotifierByType(notifierHandle.getService().getNotifierType());
            if (!(notifier instanceof LogNotifier)) continue;
            LogNotifier logNotifier = (LogNotifier)notifier;
            values[3] = notifierHandle.getActiveDescriptor().getName();
            values[4] = logNotifier.getEnabled();
        }
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        Properties extraProps = new Properties();
        map.put("enabled", values[0]);
        map.put("thresholdUnit", values[1]);
        map.put("thresholdValue", values[2]);
        map.put("notifierName", values[3]);
        map.put("notifierEnabled", values[4]);
        extraProps.put("getRequesttracingConfiguration", map);
        mainActionReport.setExtraProperties(extraProps);
        mainActionReport.setMessage(columnFormatter.toString());
        mainActionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

