/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.nucleus.notification.configuration.NotifierType;
import fish.payara.nucleus.notification.domain.LogNotificationEvent;
import fish.payara.nucleus.notification.domain.NotificationEvent;
import fish.payara.nucleus.requesttracing.RequestEventStore;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
class RequestTracingNotificationEventFactory {
    @Inject
    private RequestEventStore store;

    RequestTracingNotificationEventFactory() {
    }

    NotificationEvent build(long elapsedTime, NotifierType notifierType) {
        if (NotifierType.LOG.equals((Object)notifierType)) {
            LogNotificationEvent event = new LogNotificationEvent();
            event.setUserMessage("Request execution time: " + elapsedTime + "(ms) exceeded the acceptable threshold");
            event.setLevel(Level.INFO);
            event.setMessage(this.getRequestEventsAsStr());
            return event;
        }
        return null;
    }

    private String getRequestEventsAsStr() {
        return this.store.getTraceAsString();
    }
}

