/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.phonehome;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;

public class PhoneHomeTask
implements Runnable {
    private static final String PHONE_HOME_URL = "http://www.payara.fish/phonehome";
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final int CONN_TIMEOUT_MS = 5000;
    private static final int READ_TIMEOUT_MS = 5000;
    private static final Logger LOGGER = Logger.getLogger(PhoneHomeTask.class.getCanonicalName());
    ServerEnvironment env;
    Domain domain;

    PhoneHomeTask(Domain domain, ServerEnvironment env) {
        this.env = env;
        this.domain = domain;
    }

    @Override
    public void run() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ver", this.getVersion());
        params.put("jvm", this.getJavaVersion());
        params.put("uptime", this.getUptime());
        params.put("nodes", this.getNodeCount());
        params.put("servers", this.getServerCount());
        String targetURL = PHONE_HOME_URL + this.encodeParams(params);
        this.send(targetURL);
    }

    private String getVersion() {
        String ver = Version.getFullVersion();
        if (ver == null) {
            ver = "unknown";
        }
        return ver;
    }

    private String getJavaVersion() {
        String ver = System.getProperty("java.version");
        if (ver == null) {
            ver = "unknown";
        }
        return ver;
    }

    private String getUptime() {
        StartupContext ctx;
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        long totalTime_ms = -1L;
        if (mxbean != null) {
            totalTime_ms = mxbean.getUptime();
        }
        if (totalTime_ms <= 0L && this.env != null && (ctx = this.env.getStartupContext()) != null) {
            long start = ctx.getCreationTime();
            totalTime_ms = System.currentTimeMillis() - start;
        }
        return Long.toString(totalTime_ms);
    }

    private String getNodeCount() {
        List<Node> nodelist;
        Nodes nodes;
        String result = "unknown";
        if (this.domain != null && (nodes = this.domain.getNodes()) != null && (nodelist = nodes.getNode()) != null) {
            result = Integer.toString(nodelist.size());
        }
        return result;
    }

    private String getServerCount() {
        List<Server> serverlist;
        String result = "unknown";
        if (this.domain != null && (serverlist = this.domain.getServers().getServer()) != null) {
            result = Integer.toString(serverlist.size());
        }
        return result;
    }

    private String encodeParams(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        int seperator = 63;
        for (Map.Entry<String, String> param : params.entrySet()) {
            try {
                sb.append(String.format("%c%s=%s", Character.valueOf((char)seperator), URLEncoder.encode(param.getKey(), "UTF-8"), URLEncoder.encode(param.getValue(), "UTF-8")));
                seperator = 38;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(String target) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(target);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.getResponseCode();
        }
        catch (IOException iOException) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

