/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.service;

import com.google.common.eventbus.Subscribe;
import fish.payara.nucleus.notification.configuration.LogNotifier;
import fish.payara.nucleus.notification.configuration.LogNotifierConfiguration;
import fish.payara.nucleus.notification.configuration.NotifierType;
import fish.payara.nucleus.notification.domain.LogNotificationEvent;
import fish.payara.nucleus.notification.service.BaseNotifierService;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="service-log")
@RunLevel(value=10)
public class LogNotifierService
extends BaseNotifierService<LogNotificationEvent, LogNotifier, LogNotifierConfiguration> {
    private Logger logger = Logger.getLogger(LogNotifierService.class.getCanonicalName());

    @PostConstruct
    void postConstruct() {
        this.register(NotifierType.LOG, LogNotifier.class, LogNotifierConfiguration.class, this);
    }

    @Override
    @Subscribe
    public void handleNotification(LogNotificationEvent event) {
        if (event.getParameters() != null && event.getParameters().length > 0) {
            String formattedText = MessageFormat.format(event.getMessage(), event.getParameters());
            this.logger.log(event.getLevel(), event.getUserMessage() != null ? event.getUserMessage() + " - " + formattedText : formattedText);
        } else {
            this.logger.log(event.getLevel(), event.getUserMessage() != null ? event.getUserMessage() + " - " + event.getMessage() : event.getMessage());
        }
    }
}

