/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.HeapMemoryUsageChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-heap")
@RunLevel(value=10)
public class HeapMemoryUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, HeapMemoryUsageChecker> {
    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, HeapMemoryUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(HeapMemoryUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    public HealthCheckResult doCheck() {
        HealthCheckResult result = new HealthCheckResult();
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memBean.getHeapMemoryUsage();
        String heapValueText = String.format("heap: init: %s, used: %s, committed: %s, max.: %s", this.prettyPrintBytes(heap.getInit()), this.prettyPrintBytes(heap.getUsed()), this.prettyPrintBytes(heap.getCommitted()), this.prettyPrintBytes(heap.getMax()));
        Double percentage = this.calculatePercentage(heap);
        result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(percentage), heapValueText + "heap%: " + percentage + "%"));
        return result;
    }

    private Double calculatePercentage(MemoryUsage usage) {
        if (usage.getMax() > 0L) {
            return Math.floor((double)usage.getUsed() / (double)usage.getMax() * 100.0);
        }
        return null;
    }
}

