/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.CpuUsageChecker;
import fish.payara.nucleus.healthcheck.entity.ThreadTimes;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import fish.payara.nucleus.notification.TimeHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-cpu")
@RunLevel(value=10)
public class CpuUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, CpuUsageChecker> {
    private long timeBefore = 0L;
    private long totalTimeBefore = 0L;
    private HashMap<Long, ThreadTimes> threadTimes = new HashMap();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, CpuUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(CpuUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    public HealthCheckResult doCheck() {
        long[] ids;
        if (!this.getOptions().isEnabled()) {
            return null;
        }
        HealthCheckResult result = new HealthCheckResult();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (!threadBean.isCurrentThreadCpuTimeSupported()) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "JVM implementation or OS does not support getting CPU times"));
            return result;
        }
        for (long id : ids = threadBean.getAllThreadIds()) {
            if (id == Thread.currentThread().getId()) continue;
            long c = threadBean.getThreadCpuTime(id);
            long u = threadBean.getThreadUserTime(id);
            if (c == -1L || u == -1L) continue;
            ThreadTimes times = this.threadTimes.get(id);
            if (times == null) {
                times = new ThreadTimes();
                times.setId(id);
                times.setStartCpuTime(c);
                times.setEndCpuTime(c);
                times.setStartUserTime(u);
                times.setEndUserTime(u);
                this.threadTimes.put(id, times);
                continue;
            }
            times.setEndCpuTime(c);
            times.setEndUserTime(u);
        }
        long totalCpuTime = this.getTotalCpuTime();
        long time = System.nanoTime();
        double percentage = (double)(totalCpuTime - this.totalTimeBefore) / (double)(time - this.timeBefore) * 100.0;
        result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(percentage), "CPU%: " + new DecimalFormat("#.00").format(percentage) + ", Time CPU used: " + TimeHelper.prettyPrintDuration(TimeUnit.NANOSECONDS.toMillis(this.getTotalCpuTime() - this.totalTimeBefore))));
        this.totalTimeBefore = totalCpuTime;
        this.timeBefore = time;
        return result;
    }

    public long getTotalCpuTime() {
        Collection<ThreadTimes> threadTimesValues = this.threadTimes.values();
        long time = 0L;
        for (ThreadTimes times : threadTimesValues) {
            time += times.getEndCpuTime() - times.getStartCpuTime();
        }
        return time;
    }
}

