/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.ThresholdDiagnosticsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class BaseThresholdHealthCheck<O extends HealthCheckWithThresholdExecutionOptions, C extends ThresholdDiagnosticsChecker>
extends BaseHealthCheck<O, C> {
    public HealthCheckWithThresholdExecutionOptions constructThresholdOptions(ThresholdDiagnosticsChecker checker) {
        return new HealthCheckWithThresholdExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), checker.getPropertyValue("threshold-critical", "80"), checker.getPropertyValue("threshold-warning", "50"), checker.getPropertyValue("threshold-good", "0"));
    }

    protected HealthCheckResultStatus decideOnStatusWithRatio(Double percentage) {
        if (percentage > (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdCritical()) {
            return HealthCheckResultStatus.CRITICAL;
        }
        if (percentage > (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdWarning()) {
            return HealthCheckResultStatus.WARNING;
        }
        if (percentage >= (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdGood()) {
            return HealthCheckResultStatus.GOOD;
        }
        return HealthCheckResultStatus.FINE;
    }

    @Override
    public O getOptions() {
        return (O)((HealthCheckWithThresholdExecutionOptions)this.options);
    }
}

