/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckConstants;
import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.notification.NotificationService;
import fish.payara.nucleus.notification.domain.LogNotificationEvent;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Optional;

@Contract
public abstract class BaseHealthCheck<O extends HealthCheckExecutionOptions, C extends Checker>
implements HealthCheckConstants {
    @Inject
    protected HealthCheckService healthCheckService;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    HealthCheckServiceConfiguration configuration;
    @Inject
    NotificationService notificationService;
    protected O options;
    protected Class<C> checkerType;

    public abstract HealthCheckResult doCheck();

    public abstract O constructOptions(C var1);

    protected <T extends BaseHealthCheck> O postConstruct(T t, Class<C> checkerType) {
        this.checkerType = checkerType;
        if (this.configuration == null) {
            return null;
        }
        C checker = this.configuration.getCheckerByType(this.checkerType);
        if (checker != null) {
            this.options = this.constructOptions(checker);
            this.healthCheckService.registerCheck(checker.getName(), t);
        }
        return this.options;
    }

    protected HealthCheckExecutionOptions constructBaseOptions(Checker checker) {
        return new HealthCheckExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()));
    }

    protected TimeUnit asTimeUnit(String unit) {
        return TimeUnit.valueOf(unit);
    }

    protected HealthCheckResultStatus decideOnStatusWithDuration(long duration) {
        if (duration > 300000L) {
            return HealthCheckResultStatus.CRITICAL;
        }
        if (duration > 60000L) {
            return HealthCheckResultStatus.WARNING;
        }
        if (duration > 0L) {
            return HealthCheckResultStatus.GOOD;
        }
        return HealthCheckResultStatus.CHECK_ERROR;
    }

    protected String prettyPrintBytes(long value) {
        String result = value / 0x40000000L > 0L ? value / 0x40000000L + " Gb" : (value / 0x100000L > 0L ? value / 0x100000L + " Mb" : (value / 1024L > 0L ? value / 1024L + " Kb" : value + " bytes"));
        return result;
    }

    protected String prettyPrintStackTrace(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : elements) {
            sb.append("\tat ").append(traceElement);
        }
        return sb.toString();
    }

    public O getOptions() {
        return this.options;
    }

    public void setOptions(O options) {
        this.options = options;
    }

    public Class<C> getCheckerType() {
        return this.checkerType;
    }

    public void sendNotification(Level level, String message, Object[] parameters) {
        LogNotificationEvent notificationEvent = new LogNotificationEvent();
        notificationEvent.setLevel(level);
        notificationEvent.setMessage(message);
        notificationEvent.setParameters(parameters);
        this.notificationService.notify(notificationEvent);
    }
}

