/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.admin.HealthCheckServiceConfigurer;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.HoggingThreadsChecker;
import fish.payara.nucleus.healthcheck.preliminary.HoggingThreadsHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="healthcheck-hoggingthreads-configure")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.hoggingthreads.configure")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-hoggingthreads-configure", description="Configures the Hogging Threads Checker")})
public class HoggingThreadsConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private String time;
    @Param(name="unit", optional=true, defaultValue="SECONDS", acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String unit;
    @Param(name="name", optional=true)
    private String name;
    @Param(name="threshold-percentage", defaultValue="95")
    @Min(value=0L, message="Threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Threshold is a percentage so must be less than 100")
    private String threshold;
    @Min(value=1L, message="Retry count must be 1 or more")
    @Param(name="retry-count", defaultValue="3")
    private String retryCount;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Inject
    ServerEnvironment server;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        HoggingThreadsHealthCheck service = this.habitat.getService(HoggingThreadsHealthCheck.class, new Annotation[0]);
        final ActionReport actionReport = context.getActionReport();
        if (service == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.hoggingthreads.configure.status.error", "Hogging Threads Checker Service could not be found"));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            HealthCheckServiceConfiguration healthCheckServiceConfiguration = config.getExtensionByType(HealthCheckServiceConfiguration.class);
            HoggingThreadsChecker hoggingThreadConfiguration = healthCheckServiceConfiguration.getCheckerByType(HoggingThreadsChecker.class);
            if (hoggingThreadConfiguration == null) {
                ConfigSupport.apply(new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    @Override
                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        HoggingThreadsChecker checkerProxy = healthCheckServiceConfigurationProxy.createChild(HoggingThreadsChecker.class);
                        HoggingThreadsConfigurer.this.applyValues(checkerProxy);
                        healthCheckServiceConfigurationProxy.getCheckerList().add(checkerProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, healthCheckServiceConfiguration);
            } else {
                ConfigSupport.apply(new SingleConfigCode<HoggingThreadsChecker>(){

                    @Override
                    public Object run(HoggingThreadsChecker hoggingThreadConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        HoggingThreadsConfigurer.this.applyValues(hoggingThreadConfigurationProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return hoggingThreadConfigurationProxy;
                    }
                }, hoggingThreadConfiguration);
            }
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        HoggingThreadsChecker checkerByType = healthCheckServiceConfiguration.getCheckerByType(HoggingThreadsChecker.class);
                        service.setOptions(service.constructOptions(checkerByType));
                        this.healthCheckService.registerCheck(checkerByType.getName(), service);
                        this.healthCheckService.reboot();
                    }
                } else {
                    HoggingThreadsChecker checkerByType = healthCheckServiceConfiguration.getCheckerByType(HoggingThreadsChecker.class);
                    service.setOptions(service.constructOptions(hoggingThreadConfiguration));
                    this.healthCheckService.registerCheck(checkerByType.getName(), service);
                    this.healthCheckService.reboot();
                }
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void applyValues(HoggingThreadsChecker checkerProxy) throws PropertyVetoException {
        if (this.enabled != null) {
            checkerProxy.setEnabled(this.enabled.toString());
        }
        if (this.name != null) {
            checkerProxy.setName(this.name);
        }
        if (this.time != null) {
            checkerProxy.setTime(this.time);
        }
        if (this.unit != null) {
            checkerProxy.setUnit(this.unit);
        }
        if (this.threshold != null) {
            checkerProxy.setThresholdPercentage(this.threshold);
        }
        if (this.retryCount != null) {
            checkerProxy.setRetryCount(this.retryCount);
        }
    }
}

