/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.ThresholdDiagnosticsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="healthcheck-configure-service-threshold")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure.service.threshold")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-configure-service-threshold", description="Configures Health Check Service Notification Threshold Specified With Name")})
public class HealthCheckServiceThresholdConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceThresholdConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    HealthCheckService healthCheckService;
    @Inject
    protected Logger logger;
    @Param(name="serviceName", optional=false)
    private String serviceName;
    @Param(name="thresholdCritical", optional=true)
    private String thresholdCritical;
    @Param(name="thresholdWarning", optional=true)
    private String thresholdWarning;
    @Param(name="thresholdGood", optional=true)
    private String thresholdGood;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ServerEnvironment server;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        AdminCommandContext theContext = context;
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        BaseThresholdHealthCheck service = this.habitat.getService(BaseThresholdHealthCheck.class, this.serviceName, new Annotation[0]);
        Config config = this.targetUtil.getConfig(this.target);
        if (service == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.status.error", "Service with name {0} could not be found.", this.serviceName));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        HealthCheckServiceConfiguration healthCheckServiceConfiguration = config.getExtensionByType(HealthCheckServiceConfiguration.class);
        ThresholdDiagnosticsChecker checker = (ThresholdDiagnosticsChecker)healthCheckServiceConfiguration.getCheckerByType(service.getCheckerType());
        if (checker == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.checker.not.exists", "Health Check Service Checker Configuration with name {0} could not be found.", this.serviceName));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.evaluateThresholdProp(actionReport, checker, "threshold-critical", this.thresholdCritical);
            this.evaluateThresholdProp(actionReport, checker, "threshold-warning", this.thresholdWarning);
            this.evaluateThresholdProp(actionReport, checker, "threshold-good", this.thresholdGood);
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.dynamic.booleanValue()) {
            if (service.getOptions() == null) {
                service.setOptions(service.constructOptions(checker));
            }
            if (this.server.isDas()) {
                if (this.targetUtil.getConfig(this.target).isDas()) {
                    if (this.thresholdCritical != null) {
                        ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdCritical(Integer.valueOf(this.thresholdCritical));
                        actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.critical.success", "Critical threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdCritical));
                        actionReport.appendMessage("\n");
                    }
                    if (this.thresholdWarning != null) {
                        ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdWarning(Integer.valueOf(this.thresholdWarning));
                        actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.warning.success", "Warning threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdWarning));
                        actionReport.appendMessage("\n");
                    }
                    if (this.thresholdGood != null) {
                        ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdGood(Integer.valueOf(this.thresholdGood));
                        actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.good.success", "Good threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdGood));
                        actionReport.appendMessage("\n");
                    }
                    this.healthCheckService.reboot();
                }
            } else {
                if (this.thresholdCritical != null) {
                    ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdCritical(Integer.valueOf(this.thresholdCritical));
                    actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.critical.success", "Critical threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdCritical));
                    actionReport.appendMessage("\n");
                }
                if (this.thresholdWarning != null) {
                    ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdWarning(Integer.valueOf(this.thresholdWarning));
                    actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.warning.success", "Warning threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdWarning));
                    actionReport.appendMessage("\n");
                }
                if (this.thresholdGood != null) {
                    ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdGood(Integer.valueOf(this.thresholdGood));
                    actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.good.success", "Good threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdGood));
                    actionReport.appendMessage("\n");
                }
                this.healthCheckService.reboot();
            }
        }
    }

    private void evaluateThresholdProp(final ActionReport actionReport, ThresholdDiagnosticsChecker checker, final String name, final String value) throws TransactionFailure {
        Property thresholdProp = checker.getProperty(name);
        if (thresholdProp == null) {
            ConfigSupport.apply(new SingleConfigCode<ThresholdDiagnosticsChecker>(){

                @Override
                public Object run(ThresholdDiagnosticsChecker checkerProxy) throws PropertyVetoException, TransactionFailure {
                    Property propertyProxy = checkerProxy.createChild(Property.class);
                    HealthCheckServiceThresholdConfigurer.this.applyThreshold(propertyProxy, name, value);
                    checkerProxy.getProperty().add(propertyProxy);
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return checkerProxy;
                }
            }, checker);
        } else {
            ConfigSupport.apply(new SingleConfigCode<Property>(){

                @Override
                public Object run(Property propertyProxy) throws PropertyVetoException, TransactionFailure {
                    HealthCheckServiceThresholdConfigurer.this.applyThreshold(propertyProxy, name, value);
                    return propertyProxy;
                }
            }, thresholdProp);
        }
    }

    private void applyThreshold(Property propertyProxy, String name, String value) throws PropertyVetoException {
        if (value != null) {
            propertyProxy.setName(name);
            propertyProxy.setValue(value);
        }
    }
}

