/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-list-services")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.list.services")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-list-services", description="Lists the names of all available health check services")})
public class HealthCheckServiceLister
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceLister.class);
    @Inject
    ServiceLocator habitat;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List<ServiceHandle<BaseHealthCheck>> allServiceHandles = this.habitat.getAllServiceHandles(BaseHealthCheck.class, new Annotation[0]);
        if (allServiceHandles.isEmpty()) {
            report.appendMessage(strings.getLocalString("healthcheck.list.services.warning", "No registered health check service found."));
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(strings.getLocalString("healthcheck.list.services.availability.info", "Available Health Check Services") + ":\n");
            for (ServiceHandle<BaseHealthCheck> serviceHandle : allServiceHandles) {
                sb.append("\t" + serviceHandle.getActiveDescriptor().getName() + "\n");
            }
            report.setMessage(sb.toString());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

