/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc;

import com.sun.gjc.util.SQLTraceLogger;
import com.sun.logging.LogDomains;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.internal.api.Globals;

public class RequestTracingListener
implements SQLTraceListener {
    private RequestTracingService requestTracing;
    private static final Logger logger = LogDomains.getLogger(SQLTraceLogger.class, "javax.enterprise.resource.sqltrace");

    public RequestTracingListener() {
        try {
            this.requestTracing = Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Request Tracing service during initialisation of RequestTracingListener - NullPointerException");
        }
    }

    @Override
    public void sqlTrace(SQLTraceRecord record) {
        RequestEvent requestEvent = this.constructJDBCEvent(record);
        if (this.requestTracing != null) {
            this.requestTracing.traceRequestEvent(requestEvent);
        }
    }

    private RequestEvent constructJDBCEvent(SQLTraceRecord record) {
        RequestEvent requestEvent = new RequestEvent("JDBCContextTrace");
        requestEvent.addProperty("Method Name", record.getMethodName());
        requestEvent.addProperty("Parameters", Arrays.toString(record.getParams()));
        requestEvent.addProperty("Pool Name", record.getPoolName());
        requestEvent.addProperty("Thread ID", Long.toString(record.getThreadID()));
        requestEvent.addProperty("Thread Name", record.getThreadName());
        requestEvent.addProperty("Execution Time", Long.toString(record.getExecutionTime()));
        return requestEvent;
    }
}

