/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.MySQLJDBCConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class MySqlPersistenceManager
extends JBatchJDBCPersistenceManager
implements MySQLJDBCConstants {
    private static final String CLASSNAME = MySqlPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createMySQLStrings;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException(e);
        }
        this.tableNames = this.getSharedTableMap(batchConfig);
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException(e1);
        }
        this.createMySQLStrings = this.setCreateMySQLStringsMap(batchConfig);
        logger.config("JNDI name = " + this.jndiName);
        try {
            if (!this.isMySQLSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkMySQLTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    private boolean isMySQLSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isMySQLSchemaValid");
        boolean result = false;
        Connection conn = null;
        Object dbmd = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnectionToDefaultSchema();
            ps = conn.prepareStatement("SHOW DATABASES like ?");
            ps.setString(1, this.schema);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, ps);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, rs, ps);
        logger.exiting(CLASSNAME, "isMySQLSchemaValid", false);
        return result;
    }

    private void checkMySQLTables() throws SQLException {
        logger.entering(CLASSNAME, "checkMySQLTables");
        this.createMySQLTableNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_CHECKPOINTDATA"));
        this.createMySQLTableNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createMySQLTableNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createMySQLTableNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createMySQLTableNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_JOBSTATUS"));
        this.createMySQLTableNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkMySQLTables");
    }

    protected void createMySQLTableNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createMySQLTableNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement(1004, 1007);
            String query = "select lower(table_schema),lower(table_name) FROM information_schema.tables where lower(table_schema)= '" + this.schema + "'" + " and lower(table_name)= " + "'" + tableName.toLowerCase() + "'";
            rs = stmt.executeQuery(query);
            int rowcount = this.getTableRowCount(rs);
            if (rowcount == 0 && !rs.next()) {
                logger.log(Level.INFO, tableName + " table does not exists. Trying to create it.");
                ps = conn.prepareStatement(createTableStatement);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        finally {
            this.cleanupConnection(conn, ps);
        }
        logger.exiting(CLASSNAME, "createMySQLTableNotExists");
    }

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        Map<String, String> result = super.getSharedQueryMap(batchConfig);
        if (this.schema.equals("") || this.schema.length() == 0) {
            this.schema = this.setDefaultSchema();
        }
        result.put("Q_SET_SCHEMA", "USE " + this.schema);
        return result;
    }

    @Override
    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        PreparedStatement ps = null;
        ps = connection.prepareStatement((String)this.queryStrings.get("Q_SET_SCHEMA"));
        ps.executeUpdate();
        ps.close();
    }

    protected Map<String, String> setCreateMySQLStringsMap(IBatchConfig batchConfig) {
        this.createMySQLStrings = new HashMap<String, String>();
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + " (id VARCHAR(512),obj BLOB)");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,name VARCHAR(512), apptag VARCHAR(512))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(" + "jobexecid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT," + "jobinstanceid BIGINT," + "createtime TIMESTAMP," + "starttime TIMESTAMP," + "endtime TIMESTAMP," + "updatetime TIMESTAMP," + "parameters BLOB," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(" + "stepexecid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT," + "jobexecid BIGINT," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "stepname VARCHAR(512)," + "readcount INT," + "writecount INT," + "commitcount INT," + "rollbackcount INT," + "readskipcount INT," + "processskipcount INT," + "filtercount INT," + "writeskipcount INT," + "startTime TIMESTAMP," + "endTime TIMESTAMP," + "persistentData BLOB," + "CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + "(" + "id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT," + "obj BLOB," + "CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + (String)this.tableNames.get("STEP_STATUS_TABLE_KEY") + "(" + "id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT," + "obj BLOB," + "CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid) ON DELETE CASCADE)");
        return this.createMySQLStrings;
    }
}

