/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationInstanceFactoryMetadataMap;
import com.sun.faces.application.annotation.AnnotationManager;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.scripting.groovy.ActionListenerProxy;
import com.sun.faces.scripting.groovy.ELResolverProxy;
import com.sun.faces.scripting.groovy.NavigationHandlerProxy;
import com.sun.faces.scripting.groovy.PhaseListenerProxy;
import com.sun.faces.scripting.groovy.RendererProxy;
import com.sun.faces.scripting.groovy.ViewHandlerProxy;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProcessor
implements ConfigProcessor {
    private ConfigProcessor nextProcessor;
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String CLASS_METADATA_MAP_KEY_SUFFIX = ".METADATA";

    private ApplicationInstanceFactoryMetadataMap<String, Object> getClassMetadataMap(ServletContext sc) {
        ApplicationInstanceFactoryMetadataMap classMetadataMap = (ApplicationInstanceFactoryMetadataMap)sc.getAttribute(this.getClassMetadataMapKey());
        if (null == classMetadataMap) {
            classMetadataMap = new ApplicationInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
            sc.setAttribute(this.getClassMetadataMapKey(), classMetadataMap);
        }
        return classMetadataMap;
    }

    @Override
    public void initializeClassMetadataMap(ServletContext sc) {
        this.getClassMetadataMap(sc);
    }

    protected String getClassMetadataMapKey() {
        return this.getClass().getName() + CLASS_METADATA_MAP_KEY_SUFFIX;
    }

    @Override
    public void setNext(ConfigProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public ConfigProcessor getNext() {
        return this.nextProcessor;
    }

    @Override
    public void invokeNext(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        if (this.nextProcessor != null) {
            this.nextProcessor.process(sc, documentInfos);
        }
    }

    @Override
    public void destroyNext(ServletContext sc) {
        if (this.nextProcessor != null) {
            this.nextProcessor.destroy(sc);
        }
    }

    @Override
    public void destroy(ServletContext sc) {
        this.destroyNext(sc);
    }

    protected Application getApplication() {
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }

    protected String getNodeText(Node node) {
        String res = null;
        if (node != null && (res = node.getTextContent()) != null) {
            res = res.trim();
        }
        return res != null && res.length() != 0 ? res : null;
    }

    protected Map<String, String> getTextMap(List<Node> list) {
        if (list != null && !list.isEmpty()) {
            int len = list.size();
            HashMap<String, String> names = new HashMap<String, String>(len, 1.0f);
            for (int i = 0; i < len; ++i) {
                Node node = list.get(i);
                String textValue = this.getNodeText(node);
                if (textValue == null) continue;
                if (node.hasAttributes()) {
                    NamedNodeMap attributes = node.getAttributes();
                    String lang = this.getNodeText(attributes.getNamedItem("lang"));
                    if (lang == null) {
                        lang = this.getNodeText(attributes.getNamedItem("xml:lang"));
                    }
                    if (lang != null) {
                        names.put(lang, textValue);
                        continue;
                    }
                    names.put("DEFAULT", textValue);
                    continue;
                }
                names.put("DEFAULT", textValue);
            }
            return names;
        }
        return null;
    }

    protected Class<?> findRootType(ServletContext sc, String source, Node sourceNode, Class<?>[] ctorArguments) {
        try {
            Class<?> sourceClass = this.loadClass(sc, source, this, null);
            for (Class<?> ctorArg : ctorArguments) {
                if (ReflectionUtils.lookupConstructor(sourceClass, ctorArg) == null) continue;
                return ctorArg;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", source), sourceNode), cnfe);
        }
        return null;
    }

    protected Object createInstance(ServletContext sc, String className, Node source) {
        return this.createInstance(sc, className, null, null, source);
    }

    protected Object createInstance(ServletContext sc, String className, Class rootType, Object root, Node source) {
        boolean[] didPerformInjection = new boolean[]{false};
        Object result = this.createInstance(sc, className, rootType, root, source, true, didPerformInjection);
        return result;
    }

    protected Object createInstance(ServletContext sc, String className, Class rootType, Object root, Node source, boolean performInjection, boolean[] didPerformInjection) {
        Object returnObject;
        block14: {
            returnObject = null;
            if (className != null) {
                try {
                    ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap;
                    Constructor construct;
                    Class<?>[] interfaces;
                    Class<?> clazz = this.loadClass(sc, className, returnObject, null);
                    if (clazz == null) break block14;
                    if (this.isDevModeEnabled(sc) && (interfaces = clazz.getInterfaces()) != null) {
                        for (Class<?> c : interfaces) {
                            if (!"groovy.lang.GroovyObject".equals(c.getName())) continue;
                            returnObject = this.createScriptProxy(rootType, className, root);
                            break;
                        }
                    }
                    if (returnObject == null && rootType != null && root != null && (construct = ReflectionUtils.lookupConstructor(clazz, rootType)) != null) {
                        returnObject = construct.newInstance(root);
                    }
                    if (clazz != null && returnObject == null) {
                        returnObject = clazz.newInstance();
                    }
                    if (!(classMetadataMap = this.getClassMetadataMap(sc)).hasAnnotations(className) || !performInjection) break block14;
                    InjectionProvider injectionProvider = (InjectionProvider)FacesContext.getCurrentInstance().getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
                    try {
                        injectionProvider.inject(returnObject);
                    }
                    catch (InjectionProviderException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to inject instance" + className, ex);
                        throw new FacesException(ex);
                    }
                    try {
                        injectionProvider.invokePostConstruct(returnObject);
                    }
                    catch (InjectionProviderException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to invoke @PostConstruct annotated method on instance " + className, ex);
                        throw new FacesException(ex);
                    }
                    didPerformInjection[0] = true;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", className), source), cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", className, ncdfe.toString()), source), ncdfe);
                }
                catch (ClassCastException cce) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", className, rootType), source), cce);
                }
                catch (Exception e) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", className, e.toString()), source), e);
                }
            }
        }
        return returnObject;
    }

    protected void destroyInstance(ServletContext sc, String className, Object instance) {
        InjectionProvider injectionProvider;
        ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap;
        if (null != instance && (classMetadataMap = this.getClassMetadataMap(sc)).hasAnnotations(className) && null != (injectionProvider = (InjectionProvider)FacesContext.getCurrentInstance().getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY))) {
            try {
                injectionProvider.invokePreDestroy(instance);
            }
            catch (InjectionProviderException ex) {
                LOGGER.log(Level.SEVERE, "Unable to invoke @PreDestroy annotated method on instance " + className, ex);
                throw new FacesException(ex);
            }
        }
    }

    protected Class<?> loadClass(ServletContext sc, String className, Object fallback, Class<?> expectedType) throws ClassNotFoundException {
        ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap = this.getClassMetadataMap(sc);
        Class clazz = (Class)classMetadataMap.get(className);
        if (null == clazz) {
            try {
                clazz = Util.loadClass(className, fallback);
                if (!this.isDevModeEnabled(sc)) {
                    classMetadataMap.put(className, clazz);
                } else {
                    classMetadataMap.scanForAnnotations(className, clazz);
                }
                assert (clazz != null);
            }
            catch (Exception e) {
                throw new FacesException(e.getMessage(), e);
            }
        }
        if (expectedType != null && !expectedType.isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        return clazz;
    }

    protected void processAnnotations(Class<? extends Annotation> annotationType) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
        AnnotationManager manager = associate.getAnnotationManager();
        manager.applyConfigAnnotations(ctx, annotationType, ConfigManager.getAnnotatedClasses(ctx).get(annotationType));
    }

    private String buildMessage(String cause, Node source) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", source.getOwnerDocument().getDocumentURI(), cause);
    }

    private Object createScriptProxy(Class<?> artifactType, String scriptName, Object root) {
        if (Renderer.class.equals(artifactType)) {
            return new RendererProxy(scriptName);
        }
        if (PhaseListener.class.equals(artifactType)) {
            return new PhaseListenerProxy(scriptName);
        }
        if (ViewHandler.class.equals(artifactType)) {
            return new ViewHandlerProxy(scriptName, (ViewHandler)root);
        }
        if (NavigationHandler.class.equals(artifactType)) {
            return new NavigationHandlerProxy(scriptName, (NavigationHandler)root);
        }
        if (ActionListener.class.equals(artifactType)) {
            return new ActionListenerProxy(scriptName, (ActionListener)root);
        }
        if (ELResolver.class.equals(artifactType)) {
            return new ELResolverProxy(scriptName);
        }
        return null;
    }

    private boolean isDevModeEnabled(ServletContext sc) {
        return this.getProjectStage(sc).equals((Object)ProjectStage.Development);
    }

    private ProjectStage getProjectStage(ServletContext sc) {
        ProjectStage projectStage = null;
        String projectStageKey = AbstractConfigProcessor.class.getName() + ".PROJECTSTAGE";
        projectStage = (ProjectStage)((Object)sc.getAttribute(projectStageKey));
        if (projectStage == null) {
            block9: {
                WebConfiguration webConfig = WebConfiguration.getInstance(FacesContext.getCurrentInstance().getExternalContext());
                String value = webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ProjectStage);
                if (value != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via JNDI: {0}", value);
                    }
                } else {
                    value = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesProjectStage);
                    if (value != null && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via servlet context init parameter: {0}", value);
                    }
                }
                if (value != null) {
                    try {
                        projectStage = ProjectStage.valueOf(value);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block9;
                        LOGGER.log(Level.INFO, "Unable to discern ProjectStage for value {0}.", value);
                    }
                }
            }
            if (projectStage == null) {
                projectStage = ProjectStage.Production;
            }
            sc.setAttribute(projectStageKey, (Object)projectStage);
        }
        return projectStage;
    }
}

