/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.probes.ConnectionQueueProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.FileCacheProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.KeepAliveProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.ThreadPoolProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProviderGlobal;
import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProviderGlobal;
import com.sun.enterprise.v3.services.impl.monitor.stats.KeepAliveStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.KeepAliveStatsProviderGlobal;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProviderGlobal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyMonitoring {
    private static final String CONFIG_ELEMENT = "http-service";
    private final Map<String, ThreadPoolStatsProvider> threadPoolStatsProvidersMap = new ConcurrentHashMap<String, ThreadPoolStatsProvider>();
    private final Map<String, FileCacheStatsProvider> fileCacheStatsProvidersMap = new ConcurrentHashMap<String, FileCacheStatsProvider>();
    private final Map<String, KeepAliveStatsProvider> keepAliveStatsProvidersMap = new ConcurrentHashMap<String, KeepAliveStatsProvider>();
    private final Map<String, ConnectionQueueStatsProvider> connectionQueueStatsProvidersMap = new ConcurrentHashMap<String, ConnectionQueueStatsProvider>();
    private final ThreadPoolProbeProvider threadPoolProbeProvider = new ThreadPoolProbeProvider();
    private final FileCacheProbeProvider fileCacheProbeProvider = new FileCacheProbeProvider();
    private final KeepAliveProbeProvider keepAliveProbeProvider = new KeepAliveProbeProvider();
    private final ConnectionQueueProbeProvider connectionQueueProbeProvider = new ConnectionQueueProbeProvider();

    public ThreadPoolProbeProvider getThreadPoolProbeProvider() {
        return this.threadPoolProbeProvider;
    }

    public FileCacheProbeProvider getFileCacheProbeProvider() {
        return this.fileCacheProbeProvider;
    }

    public KeepAliveProbeProvider getKeepAliveProbeProvider() {
        return this.keepAliveProbeProvider;
    }

    public ConnectionQueueProbeProvider getConnectionQueueProbeProvider() {
        return this.connectionQueueProbeProvider;
    }

    public void registerThreadPoolStatsProvider(String name) {
        ThreadPoolStatsProvider threadPoolStatsProvider = new ThreadPoolStatsProvider(name);
        ThreadPoolStatsProvider oldthreadPoolStatsProvider = this.threadPoolStatsProvidersMap.put(name, threadPoolStatsProvider);
        if (oldthreadPoolStatsProvider != null) {
            StatsProviderManager.unregister(oldthreadPoolStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/thread-pool", threadPoolStatsProvider);
        this.updateGlobalThreadPoolStatsProvider();
    }

    public void unregisterThreadPoolStatsProvider(String name) {
        ThreadPoolStatsProvider threadPoolStatsProvider = this.threadPoolStatsProvidersMap.remove(name);
        if (threadPoolStatsProvider != null) {
            StatsProviderManager.unregister(threadPoolStatsProvider);
            this.updateGlobalThreadPoolStatsProvider();
        }
    }

    private void updateGlobalThreadPoolStatsProvider() {
        ThreadPoolStatsProvider globalThreadPoolStatsProvider = this.threadPoolStatsProvidersMap.get("");
        if (globalThreadPoolStatsProvider == null) {
            return;
        }
        int coreThreadTotal = 0;
        int maxThreadTotal = 0;
        ArrayList<String> countedThreadPoolNames = new ArrayList<String>();
        for (Map.Entry<String, ThreadPoolStatsProvider> threadPoolStatsProvider : this.threadPoolStatsProvidersMap.entrySet()) {
            String threadPoolName;
            ThreadPoolConfig threadPoolConfig;
            if (threadPoolStatsProvider.getKey().equals("") || (threadPoolConfig = (ThreadPoolConfig)threadPoolStatsProvider.getValue().getStatsObject()) == null || countedThreadPoolNames.contains(threadPoolName = threadPoolConfig.getPoolName())) continue;
            coreThreadTotal += (int)threadPoolStatsProvider.getValue().getCoreThreadsCount().getCount();
            maxThreadTotal += (int)threadPoolStatsProvider.getValue().getMaxThreadsCount().getCount();
            countedThreadPoolNames.add(threadPoolName);
        }
        globalThreadPoolStatsProvider.setCoreThreadsEvent("", "", coreThreadTotal);
        globalThreadPoolStatsProvider.setMaxThreadsEvent("", "", maxThreadTotal);
    }

    public void registerKeepAliveStatsProvider(String name) {
        KeepAliveStatsProvider keepAliveStatsProvider = new KeepAliveStatsProvider(name);
        KeepAliveStatsProvider oldKeepAliveStatsProvider = this.keepAliveStatsProvidersMap.put(name, keepAliveStatsProvider);
        if (oldKeepAliveStatsProvider != null) {
            StatsProviderManager.unregister(oldKeepAliveStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/keep-alive", keepAliveStatsProvider);
    }

    public void unregisterKeepAliveStatsProvider(String name) {
        KeepAliveStatsProvider keepAliveStatsProvider = this.keepAliveStatsProvidersMap.remove(name);
        if (keepAliveStatsProvider != null) {
            StatsProviderManager.unregister(keepAliveStatsProvider);
        }
    }

    public void registerFileCacheStatsProvider(String name) {
        FileCacheStatsProvider fileCacheStatsProvider = new FileCacheStatsProvider(name);
        FileCacheStatsProvider oldFileCacheStatsProvider = this.fileCacheStatsProvidersMap.put(name, fileCacheStatsProvider);
        if (oldFileCacheStatsProvider != null) {
            StatsProviderManager.unregister(oldFileCacheStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/file-cache", fileCacheStatsProvider);
    }

    public void unregisterFileCacheStatsProvider(String name) {
        FileCacheStatsProvider fileCacheStatsProvider = this.fileCacheStatsProvidersMap.remove(name);
        if (fileCacheStatsProvider != null) {
            StatsProviderManager.unregister(fileCacheStatsProvider);
        }
    }

    public void registerConnectionQueueStatsProvider(String name) {
        ConnectionQueueStatsProvider connectionQueueStatsProvider = new ConnectionQueueStatsProvider(name);
        ConnectionQueueStatsProvider oldConnectionQueueStatsProvider = this.connectionQueueStatsProvidersMap.put(name, connectionQueueStatsProvider);
        if (oldConnectionQueueStatsProvider != null) {
            StatsProviderManager.unregister(oldConnectionQueueStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/connection-queue", connectionQueueStatsProvider);
    }

    public void unregisterConnectionQueueStatsProvider(String name) {
        ConnectionQueueStatsProvider connectionQueueStatsProvider = this.connectionQueueStatsProvidersMap.remove(name);
        if (connectionQueueStatsProvider != null) {
            StatsProviderManager.unregister(connectionQueueStatsProvider);
        }
    }

    public void registerThreadPoolStatsProviderGlobal(String name) {
        ThreadPoolStatsProviderGlobal threadPoolStatsProvider = new ThreadPoolStatsProviderGlobal(name);
        ThreadPoolStatsProvider oldthreadPoolStatsProvider = this.threadPoolStatsProvidersMap.put(name, threadPoolStatsProvider);
        if (oldthreadPoolStatsProvider != null) {
            StatsProviderManager.unregister(oldthreadPoolStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/global-thread-pool-stats", threadPoolStatsProvider);
        this.updateGlobalThreadPoolStatsProvider();
    }

    public void unregisterThreadPoolStatsProviderGlobal(String name) {
        ThreadPoolStatsProvider threadPoolStatsProvider = this.threadPoolStatsProvidersMap.remove(name);
        if (threadPoolStatsProvider != null) {
            StatsProviderManager.unregister(threadPoolStatsProvider);
        }
    }

    public void registerKeepAliveStatsProviderGlobal(String name) {
        KeepAliveStatsProviderGlobal keepAliveStatsProvider = new KeepAliveStatsProviderGlobal(name);
        KeepAliveStatsProvider oldKeepAliveStatsProvider = this.keepAliveStatsProvidersMap.put(name, keepAliveStatsProvider);
        if (oldKeepAliveStatsProvider != null) {
            StatsProviderManager.unregister(oldKeepAliveStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/keep-alive", keepAliveStatsProvider);
    }

    public void unregisterKeepAliveStatsProviderGlobal(String name) {
        KeepAliveStatsProvider keepAliveStatsProvider = this.keepAliveStatsProvidersMap.remove(name);
        if (keepAliveStatsProvider != null) {
            StatsProviderManager.unregister(keepAliveStatsProvider);
        }
    }

    public void registerFileCacheStatsProviderGlobal(String name) {
        FileCacheStatsProviderGlobal fileCacheStatsProvider = new FileCacheStatsProviderGlobal(name);
        FileCacheStatsProvider oldFileCacheStatsProvider = this.fileCacheStatsProvidersMap.put(name, fileCacheStatsProvider);
        if (oldFileCacheStatsProvider != null) {
            StatsProviderManager.unregister(oldFileCacheStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/file-cache", fileCacheStatsProvider);
    }

    public void unregisterFileCacheStatsProviderGlobal(String name) {
        FileCacheStatsProvider fileCacheStatsProvider = this.fileCacheStatsProvidersMap.remove(name);
        if (fileCacheStatsProvider != null) {
            StatsProviderManager.unregister(fileCacheStatsProvider);
        }
    }

    public void registerConnectionQueueStatsProviderGlobal(String name) {
        ConnectionQueueStatsProviderGlobal connectionQueueStatsProvider = new ConnectionQueueStatsProviderGlobal(name);
        ConnectionQueueStatsProvider oldConnectionQueueStatsProvider = this.connectionQueueStatsProvidersMap.put(name, connectionQueueStatsProvider);
        if (oldConnectionQueueStatsProvider != null) {
            StatsProviderManager.unregister(oldConnectionQueueStatsProvider);
        }
        StatsProviderManager.register(CONFIG_ELEMENT, PluginPoint.SERVER, this.subtreePrefix(name) + "/connection-queue", connectionQueueStatsProvider);
    }

    public void unregisterConnectionQueueStatsProviderGlobal(String name) {
        ConnectionQueueStatsProvider connectionQueueStatsProvider = this.connectionQueueStatsProvidersMap.remove(name);
        if (connectionQueueStatsProvider != null) {
            StatsProviderManager.unregister(connectionQueueStatsProvider);
        }
    }

    public ConnectionQueueStatsProvider getConnectionQueueStatsProvider(String name) {
        return this.connectionQueueStatsProvidersMap.get(name);
    }

    public FileCacheStatsProvider getFileCacheStatsProvider(String name) {
        return this.fileCacheStatsProvidersMap.get(name);
    }

    public KeepAliveStatsProvider getKeepAliveStatsProvider(String name) {
        return this.keepAliveStatsProvidersMap.get(name);
    }

    public ThreadPoolStatsProvider getThreadPoolStatsProvider(String name) {
        return this.threadPoolStatsProvidersMap.get(name);
    }

    private String subtreePrefix(String name) {
        return "network/" + name;
    }
}

