/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GlassfishNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpAdapter;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.ServiceInitializerListener;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.utils.Futures;

public class GrizzlyProxy
implements NetworkProxy {
    final Logger logger;
    final NetworkListener networkListener;
    protected GrizzlyListener grizzlyListener;
    private int portNumber;
    public static final String LEADER_FOLLOWER = "org.glassfish.grizzly.useLeaderFollower";
    public static final String AUTO_CONFIGURE = "org.glassfish.grizzly.autoConfigure";
    private InetAddress address;
    private GrizzlyService grizzlyService;

    public GrizzlyProxy(GrizzlyService service, NetworkListener listener) {
        this.grizzlyService = service;
        this.logger = service.getLogger();
        this.networkListener = listener;
    }

    public void initialize() throws IOException {
        String port = this.networkListener.getPort();
        this.portNumber = 8080;
        if (port == null) {
            this.logger.severe("NCLS-CORE-00084");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.SEVERE, "NCLS-CORE-00085", port);
        }
        try {
            this.address = InetAddress.getByName(this.networkListener.getAddress());
        }
        catch (UnknownHostException ex) {
            LogHelper.log(this.logger, Level.SEVERE, "NCLS-CORE-00086", ex, this.address);
        }
        this.grizzlyListener = this.createGrizzlyListener(this.networkListener);
        this.grizzlyListener.configure(this.grizzlyService.getHabitat(), this.networkListener);
    }

    protected GrizzlyListener createGrizzlyListener(NetworkListener networkListener) {
        if (GrizzlyService.isLightWeightListener(networkListener)) {
            return this.createServiceInitializerListener(networkListener);
        }
        return this.createGlassfishListener(networkListener);
    }

    protected GrizzlyListener createGlassfishListener(NetworkListener networkListener) {
        return new GlassfishNetworkListener(this.grizzlyService, networkListener, this.logger);
    }

    protected GrizzlyListener createServiceInitializerListener(NetworkListener networkListener) {
        return new ServiceInitializerListener(this.grizzlyService, networkListener, this.logger);
    }

    static ArrayList<String> toArray(String list, String token) {
        return new ArrayList<String>(Arrays.asList(list.split(token)));
    }

    @Override
    public void stop() throws IOException {
        this.grizzlyListener.stop();
    }

    @Override
    public void destroy() {
        this.grizzlyListener.destroy();
    }

    public String toString() {
        return "GrizzlyProxy{address=" + this.address + ", portNumber=" + this.portNumber + '}';
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, HttpHandler endpointService, ApplicationContainer container) throws EndpointRegistrationException {
        if (contextRoot == null) {
            return;
        }
        if (endpointService == null) {
            throw new EndpointRegistrationException("The endpoint adapter is null");
        }
        HttpAdapter httpAdapter = this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().register(contextRoot, vsServers, endpointService, container);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        HttpAdapter httpAdapter = this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().unregister(contextRoot);
        }
    }

    @Override
    public void registerEndpoint(Endpoint endpoint) {
        HttpAdapter httpAdapter = this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().register(endpoint);
        }
    }

    @Override
    public void unregisterEndpoint(Endpoint endpoint) throws EndpointRegistrationException {
        this.unregisterEndpoint(endpoint.getContextRoot(), endpoint.getContainer());
    }

    @Override
    public Future<Result<Thread>> start() throws IOException {
        FutureImpl<Result<Thread>> future = Futures.createUnsafeFuture();
        if (!GrizzlyProxy.isAjpEnabled(this.grizzlyListener)) {
            this.start0();
        } else {
            this.grizzlyService.addServerReadyListener(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GrizzlyProxy.this.start0();
                    return null;
                }
            });
        }
        future.result(new Result<Thread>(Thread.currentThread()));
        return future;
    }

    protected void start0() throws IOException {
        long t1 = System.currentTimeMillis();
        try {
            this.grizzlyListener.start();
        }
        catch (BindException e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00097", new Object[]{Grizzly.getDotedVersion(), this.grizzlyListener.getAddress() + ":" + this.grizzlyListener.getPort()});
            }
            throw e;
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "NCLS-CORE-00087", new Object[]{Grizzly.getDotedVersion(), System.currentTimeMillis() - t1, this.grizzlyListener.getAddress() + ":" + this.grizzlyListener.getPort()});
        }
    }

    @Override
    public int getPort() {
        return this.portNumber;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public GrizzlyListener getUnderlyingListener() {
        return this.grizzlyListener;
    }

    private static boolean isAjpEnabled(GrizzlyListener grizzlyListener) {
        return grizzlyListener instanceof GenericGrizzlyListener && ((GenericGrizzlyListener)grizzlyListener).isAjpEnabled();
    }
}

