/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.types.EntityManagerFactoryReference;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.EntityManagerFactory;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.security.common.Role;

public abstract class BundleDescriptor
extends RootDeploymentDescriptor
implements Roles {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BundleDescriptor.class);
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "META-INF";
    private static final String WSDL_DIR = "wsdl";
    private static final double ANNOTATION_RAR_VER = 1.6;
    private static final double ANNOTATION_EJB_VER = 3.0;
    private static final double ANNOTATION_WAR_VER = 2.5;
    private static final double ANNOTATION_CAR_VER = 5.0;
    private boolean fullFlag = false;
    private boolean fullAttribute = false;
    private final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private Application application;
    private Set<Role> roles;
    private Set<MessageDestinationDescriptor> messageDestinations = new HashSet<MessageDestinationDescriptor>();
    private WebServicesDescriptor webServices = new WebServicesDescriptor();
    private Set<ManagedBeanDescriptor> managedBeans = new HashSet<ManagedBeanDescriptor>();
    private Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private Hashtable<InjectionInfoCacheKey, InjectionInfo> injectionInfos = new Hashtable();
    private boolean policyModified = false;
    private String compatValue;
    private boolean keepState = false;
    private boolean defaultGroupPrincipalMapping = false;
    protected HashMap<String, RootXMLNode> rootNodes = new HashMap();

    public BundleDescriptor() {
        this.webServices.setBundleDescriptor(this);
    }

    public BundleDescriptor(String name, String description) {
        super(name, description);
        this.webServices.setBundleDescriptor(this);
    }

    public void setApplication(Application a) {
        this.application = a;
        for (List extensionsByType : this.extensions.values()) {
            for (RootDeploymentDescriptor extension : extensionsByType) {
                if (!(extension instanceof BundleDescriptor)) continue;
                ((BundleDescriptor)extension).setApplication(a);
            }
        }
    }

    public void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        for (MessageDestinationDescriptor mdDesc : bundleDescriptor.getMessageDestinations()) {
            this.addMessageDestination(mdDesc);
        }
    }

    public boolean isPackagedAsSingleModule(BundleDescriptor other) {
        return this.getModuleDescriptor().equals(other.getModuleDescriptor());
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    public boolean isStandalone() {
        return this.application.isVirtual();
    }

    public Application getApplication() {
        return this.application;
    }

    public void addRootNode(String ddPath, RootXMLNode rootNode) {
        this.rootNodes.put(ddPath, rootNode);
    }

    public RootXMLNode getRootNode(String ddPath) {
        return this.rootNodes.get(ddPath);
    }

    public void addEntityManagerFactory(String unitName, EntityManagerFactory emf) {
        this.entityManagerFactories.put(unitName, emf);
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.entityManagerFactories.get(unitName);
    }

    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    public void addManagedBean(ManagedBeanDescriptor desc) {
        if (!this.hasManagedBeanByBeanClass(desc.getBeanClassName())) {
            this.managedBeans.add(desc);
            desc.setBundle(this);
        }
    }

    public boolean hasManagedBeanByBeanClass(String beanClassName) {
        ManagedBeanDescriptor descriptor = this.getManagedBeanByBeanClass(beanClassName);
        return descriptor != null;
    }

    public ManagedBeanDescriptor getManagedBeanByBeanClass(String beanClassName) {
        ManagedBeanDescriptor match = null;
        for (ManagedBeanDescriptor next : this.managedBeans) {
            if (!beanClassName.equals(next.getBeanClassName())) continue;
            match = next;
            break;
        }
        return match;
    }

    public Set<ManagedBeanDescriptor> getManagedBeans() {
        return new HashSet<ManagedBeanDescriptor>(this.managedBeans);
    }

    public WebServicesDescriptor getWebServices() {
        return this.webServices;
    }

    public WebServiceEndpoint getWebServiceEndpointByName(String name) {
        return this.webServices.getEndpointByName(name);
    }

    public boolean hasWebServiceClients() {
        return false;
    }

    public boolean hasWebServices() {
        return this.getWebServices().hasWebServices();
    }

    public Set<MessageDestinationDescriptor> getMessageDestinations() {
        if (this.messageDestinations == null) {
            this.messageDestinations = new HashSet<MessageDestinationDescriptor>();
        }
        return this.messageDestinations;
    }

    public boolean hasMessageDestinationByName(String name) {
        for (MessageDestinationDescriptor mtd : this.getMessageDestinations()) {
            if (!mtd.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationDescriptor getMessageDestinationByName(String name) {
        for (MessageDestinationDescriptor mtd : this.getMessageDestinations()) {
            if (!mtd.getName().equals(name)) continue;
            return mtd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmessagedestbundle", "Referencing error: this bundle has no message destination of name: {0}", name));
    }

    public void addMessageDestination(MessageDestinationDescriptor messageDestination) {
        messageDestination.setBundleDescriptor(this);
        this.getMessageDestinations().add(messageDestination);
    }

    public void removeMessageDestination(MessageDestinationDescriptor msgDest) {
        msgDest.setBundleDescriptor(null);
        this.getMessageDestinations().remove(msgDest);
    }

    @Override
    public Set<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet<Role>();
        }
        if (this.application != null) {
            this.roles.addAll(this.application.getAppRoles());
        }
        return this.roles;
    }

    @Override
    public void addRole(Role role) {
        this.getRoles().add(role);
    }

    public void addRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.addRole(role);
    }

    @Override
    public void removeRole(Role role) {
        this.getRoles().remove(role);
    }

    protected Collection getNamedDescriptorsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<EnvironmentProperty> namedDescriptors = new Vector<EnvironmentProperty>();
        for (ResourceReferenceDescriptor resourceReference : nameEnvironment.getResourceReferenceDescriptors()) {
            namedDescriptors.add(resourceReference);
        }
        for (EjbReferenceDescriptor ejbReference : nameEnvironment.getEjbReferenceDescriptors()) {
            namedDescriptors.add(ejbReference);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvRef : nameEnvironment.getResourceEnvReferenceDescriptors()) {
            namedDescriptors.add(resourceEnvRef);
        }
        return namedDescriptors;
    }

    protected Vector<NamedReferencePair> getNamedReferencePairsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        for (ResourceReferenceDescriptor resourceReference : nameEnvironment.getResourceReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceRefPair((Descriptor)((Object)nameEnvironment), resourceReference));
        }
        for (EjbReferenceDescriptor ejbReference : nameEnvironment.getEjbReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createEjbRefPair((Descriptor)((Object)nameEnvironment), ejbReference));
        }
        for (ResourceEnvReferenceDescriptor resourceEnvRef : nameEnvironment.getResourceEnvReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceEnvRefPair((Descriptor)((Object)nameEnvironment), resourceEnvRef));
        }
        return pairs;
    }

    public InjectionInfo getInjectionInfoByClass(Class clazz, JndiNameEnvironment jndiNameEnv) {
        InjectionInfoCacheKey key = null;
        if (jndiNameEnv instanceof EjbDescriptor) {
            EjbDescriptor jndiEjbDesc = (EjbDescriptor)jndiNameEnv;
            key = new InjectionInfoCacheKey(jndiEjbDesc.getName(), clazz);
        } else {
            key = new InjectionInfoCacheKey(clazz.getName(), clazz);
        }
        InjectionInfo injectionInfo = this.injectionInfos.get(key);
        if (injectionInfo != null) {
            return injectionInfo;
        }
        String className = clazz.getName();
        LifecycleCallbackDescriptor postConstructDesc = this.getPostConstructDescriptorByClass(className, jndiNameEnv);
        String postConstructMethodName = postConstructDesc != null ? postConstructDesc.getLifecycleCallbackMethod() : null;
        LifecycleCallbackDescriptor preDestroyDesc = this.getPreDestroyDescriptorByClass(className, jndiNameEnv);
        String preDestroyMethodName = preDestroyDesc != null ? preDestroyDesc.getLifecycleCallbackMethod() : null;
        injectionInfo = new InjectionInfo(className, postConstructMethodName, preDestroyMethodName, this.getInjectableResourcesByClass(className, jndiNameEnv));
        this.injectionInfos.put(key, injectionInfo);
        return injectionInfo;
    }

    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public List<InjectionCapable> getInjectableResources(JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        this.addJndiNameEnvironmentInjectables(jndiNameEnv, injectables);
        return injectables;
    }

    private void addJndiNameEnvironmentInjectables(JndiNameEnvironment jndiNameEnv, List<InjectionCapable> injectables) {
        HashSet<EnvironmentProperty> allEnvProps = new HashSet<EnvironmentProperty>();
        for (EnvironmentProperty environmentProperty : jndiNameEnv.getEnvironmentProperties()) {
            if (!environmentProperty.hasAValue() && !(jndiNameEnv instanceof EjbBundleDescriptor)) continue;
            allEnvProps.add(environmentProperty);
        }
        allEnvProps.addAll(jndiNameEnv.getEjbReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getServiceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getResourceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getResourceEnvReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getMessageDestinationReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerFactoryReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerReferenceDescriptors());
        for (InjectionCapable injectionCapable : allEnvProps) {
            if (!injectionCapable.isInjectable()) continue;
            injectables.add(injectionCapable);
        }
    }

    protected List<InjectionCapable> getInjectableResourcesByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        for (InjectionCapable next : this.getInjectableResources(jndiNameEnv)) {
            if (!next.isInjectable()) continue;
            for (InjectionTarget target : next.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectables.add(next);
            }
        }
        return injectables;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.application != null) {
            return this.application.getClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n Roles[] = ").append(this.roles);
        if (this.getWebServices().hasWebServices()) {
            toStringBuffer.append("\n WebServices ");
            ((Descriptor)this.getWebServices()).print(toStringBuffer);
        }
    }

    @Override
    public abstract ArchiveType getModuleType();

    public ComponentVisitor getBundleVisitor() {
        return new ApplicationValidator();
    }

    public void visit(ComponentVisitor aVisitor) {
        aVisitor.accept(this);
    }

    @Override
    public String getModuleID() {
        if (this.moduleID == null) {
            this.moduleID = this.getModuleDescriptor().getArchiveUri();
        }
        if (this.getModuleDescriptor().isStandalone()) {
            return this.moduleID;
        }
        if (this.application != null && !this.application.isVirtual()) {
            return this.application.getRegistrationName() + "#" + this.getModuleDescriptor().getArchiveUri();
        }
        return this.moduleID;
    }

    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    public String getWsdlDir() {
        return this.getDeploymentDescriptorDir() + "/" + WSDL_DIR;
    }

    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        return Collections.EMPTY_LIST;
    }

    protected static Collection<? extends PersistenceUnitDescriptor> findReferencedPUsViaPURefs(JndiNameEnvironment component) {
        HashSet<PersistenceUnitDescriptor> pus = new HashSet<PersistenceUnitDescriptor>();
        for (EntityManagerFactoryReference entityManagerFactoryReference : component.getEntityManagerFactoryReferenceDescriptors()) {
            PersistenceUnitDescriptor pu = BundleDescriptor.findReferencedPUViaEMFRef(entityManagerFactoryReference);
            pus.add(pu);
        }
        return pus;
    }

    protected static PersistenceUnitDescriptor findReferencedPUViaEMFRef(EntityManagerFactoryReference emfRef) {
        String unitName = emfRef.getUnitName();
        BundleDescriptor bundle2 = emfRef.getReferringBundleDescriptor();
        PersistenceUnitDescriptor pu = bundle2.findReferencedPU(unitName);
        if (pu == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-unresolved-pu-ref", "xxx", emfRef.getName(), bundle2.getName()));
        }
        return pu;
    }

    protected static Collection<? extends PersistenceUnitDescriptor> findReferencedPUsViaPCRefs(JndiNameEnvironment component) {
        HashSet<PersistenceUnitDescriptor> pus = new HashSet<PersistenceUnitDescriptor>();
        for (EntityManagerReference entityManagerReference : component.getEntityManagerReferenceDescriptors()) {
            PersistenceUnitDescriptor pu = BundleDescriptor.findReferencedPUViaEMRef(entityManagerReference);
            pus.add(pu);
        }
        return pus;
    }

    protected static PersistenceUnitDescriptor findReferencedPUViaEMRef(EntityManagerReference emRef) {
        String unitName = emRef.getUnitName();
        BundleDescriptor bundle2 = emRef.getReferringBundleDescriptor();
        PersistenceUnitDescriptor pu = bundle2.findReferencedPU(unitName);
        if (pu == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-unresolved-pc-ref", "xxx", emRef.getName(), bundle2.getName()));
        }
        if ("RESOURCE_LOCAL".equals(pu.getTransactionType())) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-non-jta-container-managed-em", "xxx", emRef.getName(), bundle2.getName(), pu.getName()));
        }
        return pu;
    }

    public PersistenceUnitDescriptor findReferencedPU(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return this.findDefaultPU();
        }
        return this.findReferencedPU0(unitName);
    }

    public PersistenceUnitDescriptor findDefaultPU() {
        PersistenceUnitDescriptor pu = null;
        int totalNumberOfPUInBundle = 0;
        for (PersistenceUnitsDescriptor nextPUs : this.getModuleDescriptor().getDescriptor().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            Iterator<PersistenceUnitDescriptor> i$ = nextPUs.getPersistenceUnitDescriptors().iterator();
            while (i$.hasNext()) {
                PersistenceUnitDescriptor nextPU;
                pu = nextPU = i$.next();
                ++totalNumberOfPUInBundle;
            }
        }
        if (totalNumberOfPUInBundle == 1) {
            return pu;
        }
        if (totalNumberOfPUInBundle == 0) {
            int totalNumberOfPUInEar = 0;
            for (PersistenceUnitsDescriptor nextPUs : this.getApplication().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                Iterator<PersistenceUnitDescriptor> i$ = nextPUs.getPersistenceUnitDescriptors().iterator();
                while (i$.hasNext()) {
                    PersistenceUnitDescriptor nextPU;
                    pu = nextPU = i$.next();
                    ++totalNumberOfPUInEar;
                }
            }
            if (totalNumberOfPUInEar == 1) {
                return pu;
            }
        }
        return null;
    }

    private PersistenceUnitDescriptor findReferencedPU0(String unitName) {
        int separatorIndex = unitName.lastIndexOf("#");
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String puRoot = this.getTargetUri(this, path);
            PersistenceUnitsDescriptor pus = (PersistenceUnitsDescriptor)this.getApplication().getExtensionsDescriptors(PersistenceUnitsDescriptor.class, puRoot);
            if (pus != null) {
                for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                    if (!pu.getName().equals(unqualifiedUnitName)) continue;
                    return pu;
                }
            }
        } else {
            Map<String, PersistenceUnitDescriptor> visiblePUs = this.getVisiblePUs();
            PersistenceUnitDescriptor result = visiblePUs.get(unitName);
            if (result != null) {
                return result;
            }
            int sameNamedEarScopedPUCount = 0;
            Set<Map.Entry<String, PersistenceUnitDescriptor>> entrySet = visiblePUs.entrySet();
            for (Map.Entry<String, PersistenceUnitDescriptor> entry : entrySet) {
                String s = entry.getKey();
                int idx = s.lastIndexOf("#");
                if (idx == -1 || !s.substring(idx + 1).matches(unitName)) continue;
                result = entry.getValue();
                ++sameNamedEarScopedPUCount;
            }
            if (sameNamedEarScopedPUCount == 1) {
                return result;
            }
        }
        return null;
    }

    public Map<String, PersistenceUnitDescriptor> getVisiblePUs() {
        HashMap<String, PersistenceUnitDescriptor> result = new HashMap<String, PersistenceUnitDescriptor>();
        for (PersistenceUnitsDescriptor pus : this.getModuleDescriptor().getDescriptor().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                result.put(pu.getName(), pu);
            }
        }
        Application application = this.getApplication();
        if (application != null) {
            for (PersistenceUnitsDescriptor pus : application.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                    result.put(pu.getPuRoot() + "#" + pu.getName(), pu);
                }
            }
        }
        return result;
    }

    private String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            return new URI(archiveUri).resolve(relativeTargetUri).getPath();
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public String getModuleName() {
        String moduleName = null;
        moduleName = this.getApplication().isVirtual() ? this.getApplication().getRegistrationName() : this.getModuleDescriptor().getArchiveUri();
        return moduleName;
    }

    public String getUniqueFriendlyId() {
        return FileUtils.makeFriendlyFilename(this.getModuleName());
    }

    public boolean isPolicyModified() {
        return this.policyModified;
    }

    public void setPolicyModified(boolean policyModified) {
        this.policyModified = policyModified;
    }

    public String getCompatibility() {
        return this.compatValue;
    }

    public void setCompatibility(String compatValue) {
        this.compatValue = compatValue;
    }

    public boolean getKeepState() {
        return this.keepState;
    }

    public void setKeepState(String keepStateVal) {
        this.keepState = Boolean.valueOf(keepStateVal);
    }

    public boolean isDefaultGroupPrincipalMapping() {
        return this.defaultGroupPrincipalMapping;
    }

    public void setDefaultGroupPrincipalMapping(boolean defaultGroupPrincipalMapping) {
        this.defaultGroupPrincipalMapping = defaultGroupPrincipalMapping;
    }

    public void setFullFlag(boolean flag) {
        this.fullFlag = flag;
    }

    public void setFullAttribute(String value) {
        this.fullAttribute = Boolean.valueOf(value);
    }

    public boolean isFullAttribute() {
        return this.fullAttribute;
    }

    public boolean isFullFlag() {
        if (this.fullAttribute || this.fullFlag) {
            return true;
        }
        return this.isDDWithNoAnnotationAllowed();
    }

    public boolean isDDWithNoAnnotationAllowed() {
        ArchiveType mType = this.getModuleType();
        if (mType == null) {
            return false;
        }
        double specVersion = Double.parseDouble(this.getSpecVersion());
        return mType.equals(DOLUtils.ejbType()) && specVersion < 3.0 || mType.equals(DOLUtils.warType()) && specVersion < 2.5 || mType.equals(DOLUtils.carType()) && specVersion < 5.0 || mType.equals(DOLUtils.rarType()) && specVersion < 1.6;
    }

    private static final class InjectionInfoCacheKey {
        String beanName;
        Class clazz;
        int hc;

        InjectionInfoCacheKey(String beanName, Class clazz) {
            this.beanName = beanName;
            this.clazz = clazz;
            this.hc = beanName.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof InjectionInfoCacheKey) {
                InjectionInfoCacheKey other = (InjectionInfoCacheKey)o;
                if (this.hc == other.hc) {
                    return this.clazz == other.clazz && this.beanName.equals(other.beanName);
                }
            }
            return result;
        }
    }
}

