/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.admin.util.InstanceRestCommandExecutor;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;

public class ClusterOperationUtil {
    private static final Logger logger = AdminLoggerInfo.getLogger();
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(ClusterOperationUtil.class);
    private static List<Server> completedInstances = new ArrayList<Server>();

    public static List<Server> getCompletedInstances() {
        return completedInstances;
    }

    public static void clearInstanceList() {
        completedInstances.clear();
    }

    private static boolean useRest() {
        return true;
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, FailurePolicy neverStartedPolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, ServiceLocator habitat) {
        return ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, neverStartedPolicy, instancesForReplication, context, parameters, habitat, null);
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, FailurePolicy neverStartedPolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, ServiceLocator habitat, File intermediateDownloadDir) {
        long maxWaitTime;
        HashMap<String, Future<InstanceCommandResult>> futures;
        InstanceStateService instanceState;
        ActionReport.ExitCode returnValue;
        block25: {
            ActionReport.ExitCode finalResult;
            returnValue = ActionReport.ExitCode.SUCCESS;
            instanceState = habitat.getService(InstanceStateService.class, new Annotation[0]);
            ClusterOperationUtil.validateIntermediateDownloadDir(intermediateDownloadDir);
            RemoteInstanceCommandHelper rich = new RemoteInstanceCommandHelper(habitat);
            futures = new HashMap<String, Future<InstanceCommandResult>>();
            try {
                for (Server svr : instancesForReplication) {
                    Future<InstanceCommandResult> f;
                    InstanceCommand ice;
                    ActionReport aReport;
                    if (instanceState.getState(svr.getName()) == InstanceState.StateType.NEVER_STARTED) {
                        finalResult = FailurePolicy.applyFailurePolicy(neverStartedPolicy, ActionReport.ExitCode.FAILURE);
                        if (finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                        aReport = context.getActionReport().addSubActionsReport();
                        if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                            aReport.setMessage(strings.getLocalString("clusterutil.failneverstarted", "FAILURE: Instance {0} has never been started; command {1} was not replicated to that instance", svr.getName(), commandName));
                        } else {
                            aReport.setMessage(strings.getLocalString("clusterutil.warnneverstarted", "WARNING: Instance {0} has never been started; command {1} was not replicated to that instance", svr.getName(), commandName));
                        }
                        aReport.setActionExitCode(finalResult);
                        if (returnValue != ActionReport.ExitCode.SUCCESS) continue;
                        returnValue = finalResult;
                        continue;
                    }
                    Config scfg = svr.getConfig();
                    if (!Boolean.valueOf(scfg.getDynamicReconfigurationEnabled()).booleanValue()) {
                        aReport = context.getActionReport().addSubActionsReport();
                        aReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                        aReport.setMessage(strings.getLocalString("clusterutil.dynrecfgdisabled", "WARNING: The command {0} was not replicated to instance {1} because the dynamic-reconfiguration-enabled flag is set to false for config {2}", commandName, svr.getName(), scfg.getName()));
                        instanceState.setState(svr.getName(), InstanceState.StateType.RESTART_REQUIRED, false);
                        instanceState.addFailedCommandToInstance(svr.getName(), commandName, parameters);
                        returnValue = ActionReport.ExitCode.WARNING;
                        continue;
                    }
                    String host = svr.getAdminHost();
                    int port = rich.getAdminPort(svr);
                    ActionReport aReport2 = context.getActionReport().addSubActionsReport();
                    InstanceCommandResult aResult = new InstanceCommandResult();
                    if (ClusterOperationUtil.useRest()) {
                        ice = new InstanceRestCommandExecutor(habitat, commandName, failPolicy, offlinePolicy, svr, host, port, logger, parameters, aReport2, aResult);
                        if (CommandTarget.DAS.isValid(habitat, ((InstanceRestCommandExecutor)ice).getServer().getName())) continue;
                        if (intermediateDownloadDir != null) {
                            ((RemoteRestAdminCommand)((Object)ice)).setFileOutputDirectory(new File(intermediateDownloadDir, ((InstanceRestCommandExecutor)ice).getServer().getName()));
                        }
                        f = instanceState.submitJob(svr, ice, aResult);
                    } else {
                        logger.log(Level.FINEST, "replicateCommand(): Use traditional way for replication - {0}", commandName);
                        ice = new InstanceCommandExecutor(habitat, commandName, failPolicy, offlinePolicy, svr, host, port, logger, parameters, aReport2, aResult);
                        if (CommandTarget.DAS.isValid(habitat, ((InstanceCommandExecutor)ice).getServer().getName())) continue;
                        if (intermediateDownloadDir != null) {
                            ((RemoteAdminCommand)((Object)ice)).setFileOutputDirectory(new File(intermediateDownloadDir, ((InstanceCommandExecutor)ice).getServer().getName()));
                        }
                        f = instanceState.submitJob(svr, ice, aResult);
                    }
                    if (f == null) {
                        logger.severe("NCLS-ADMIN-00001");
                        continue;
                    }
                    futures.put(svr.getName(), f);
                    logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.jobsubmitted", "Successfully submitted command {0} for execution at instance {1}", commandName, svr.getName()));
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                finalResult = FailurePolicy.applyFailurePolicy(failPolicy, ActionReport.ExitCode.FAILURE);
                aReport.setActionExitCode(finalResult);
                aReport.setMessage(strings.getLocalString("clusterutil.replicationfailed", "Error during command replication: {0}", ex.getLocalizedMessage()));
                logger.log(Level.SEVERE, "NCLS-ADMIN-00002", ex.getLocalizedMessage());
                if (returnValue != ActionReport.ExitCode.SUCCESS) break block25;
                returnValue = finalResult;
            }
        }
        boolean gotFirstResponse = false;
        long timeBeforeAsadminTimeout = maxWaitTime = (long)RemoteRestAdminCommand.getReadTimeout();
        long waitStart = System.currentTimeMillis();
        for (Map.Entry fe : futures.entrySet()) {
            ActionReport.ExitCode finalResult;
            String s = (String)fe.getKey();
            try {
                Server iServer;
                ActionReport iReport;
                InstanceCommand ice;
                logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.waitingonjob", "Waiting for command {0} to be completed at instance {1}", commandName, s));
                Future aFuture = (Future)fe.getValue();
                InstanceCommandResult aResult = (InstanceCommandResult)aFuture.get(maxWaitTime, TimeUnit.MILLISECONDS);
                long elapsedTime = System.currentTimeMillis() - waitStart;
                timeBeforeAsadminTimeout -= elapsedTime;
                if (!gotFirstResponse) {
                    maxWaitTime = elapsedTime * 4L;
                    gotFirstResponse = true;
                }
                if (maxWaitTime > timeBeforeAsadminTimeout || maxWaitTime < 60000L) {
                    maxWaitTime = timeBeforeAsadminTimeout;
                }
                if (ClusterOperationUtil.useRest()) {
                    ice = (InstanceRestCommandExecutor)aResult.getInstanceCommand();
                    iReport = ((InstanceRestCommandExecutor)ice).getReport();
                    iServer = ((InstanceRestCommandExecutor)ice).getServer();
                } else {
                    ice = (InstanceCommandExecutor)aResult.getInstanceCommand();
                    iReport = ((InstanceCommandExecutor)ice).getReport();
                    iServer = ((InstanceCommandExecutor)ice).getServer();
                }
                if (iReport.getActionExitCode() != ActionReport.ExitCode.FAILURE) {
                    completedInstances.add(iServer);
                }
                finalResult = FailurePolicy.applyFailurePolicy(failPolicy, iReport.getActionExitCode());
                if (returnValue == ActionReport.ExitCode.SUCCESS) {
                    returnValue = finalResult;
                }
                if (finalResult == ActionReport.ExitCode.SUCCESS) continue;
                instanceState.setState(s, InstanceState.StateType.RESTART_REQUIRED, false);
                instanceState.addFailedCommandToInstance(s, commandName, parameters);
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                finalResult = FailurePolicy.applyFailurePolicy(failPolicy, ActionReport.ExitCode.FAILURE);
                if (finalResult == ActionReport.ExitCode.FAILURE) {
                    if (ex instanceof TimeoutException) {
                        aReport.setMessage(strings.getLocalString("clusterutil.timeoutwhilewaiting", "Timed out while waiting for result from instance {0}", s));
                    } else {
                        aReport.setMessage(strings.getLocalString("clusterutil.exceptionwhilewaiting", "Exception while waiting for result from instance {0} : {1}", s, ex.getLocalizedMessage()));
                    }
                }
                aReport.setActionExitCode(finalResult);
                if (returnValue == ActionReport.ExitCode.SUCCESS) {
                    returnValue = finalResult;
                }
                instanceState.setState(s, InstanceState.StateType.RESTART_REQUIRED, false);
                instanceState.addFailedCommandToInstance(s, commandName, parameters);
            }
        }
        return returnValue;
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, FailurePolicy neverStartedPolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, ServiceLocator habitat) {
        return ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, neverStartedPolicy, targetNames, context, parameters, habitat, null);
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, FailurePolicy neverStartedPolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, ServiceLocator habitat, File intermediateDownloadDir) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        Target targetService = habitat.getService(Target.class, new Annotation[0]);
        for (String t : targetNames) {
            if (CommandTarget.DAS.isValid(habitat, t) || CommandTarget.DOMAIN.isValid(habitat, t)) continue;
            parameters.set("target", t);
            ActionReport.ExitCode returnValue = ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, neverStartedPolicy, targetService.getInstances(t), context, parameters, habitat, intermediateDownloadDir);
            if (returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
            result = returnValue;
        }
        return result;
    }

    private static void validateIntermediateDownloadDir(File dir) {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException(strings.getLocalString("clusterutil.errCreDir", "Could not create directory {0}; no further information available", dir.getAbsolutePath()));
            }
        } else if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException(dir.getAbsolutePath());
        }
    }
}

