/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.embeddable;

import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.EmbeddedSystemAdministrator;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ContractsProvided(value={org.glassfish.embeddable.CommandRunner.class, CommandExecutorImpl.class})
public class CommandExecutorImpl
implements org.glassfish.embeddable.CommandRunner {
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServiceLocator habitat;
    @Inject
    private EmbeddedSystemAdministrator embeddedSystemAdministrator;
    private boolean terse;
    private Logger logger = Logger.getAnonymousLogger();

    @Override
    public CommandResult run(String command, String ... args) {
        try {
            ActionReport actionReport = this.executeCommand(command, args);
            return this.convert(actionReport);
        }
        catch (Exception e) {
            return this.convert(e);
        }
    }

    ParameterMap getParameters(String command, String[] args) throws CommandException {
        String pwfile;
        CommandModel commandModel = this.commandRunner.getModel(command, this.logger);
        if (commandModel == null) {
            throw new CommandException("Command lookup failed for command " + command);
        }
        Parser parser = new Parser(args, 0, ProgramOptions.getValidOptions(), true);
        ParameterMap globalOptions = parser.getOptions();
        List<String> operands = parser.getOperands();
        String[] argv = operands.toArray(new String[operands.size()]);
        parser = new Parser(argv, 0, commandModel.getParameters(), false);
        ParameterMap options = parser.getOptions();
        operands = parser.getOperands();
        options.set("DEFAULT", operands);
        if (commandModel.getModelFor("terse") != null) {
            options.set("terse", Boolean.toString(this.terse));
        }
        if (globalOptions.size() > 0 && (pwfile = (String)globalOptions.getOne("passwordfile")) != null && pwfile.length() > 0) {
            Map<String, String> passwords = CLIUtil.readPasswordFileOptions(pwfile, false);
            for (CommandModel.ParamModel opt : commandModel.getParameters()) {
                String pwdname;
                String pwd;
                if (!opt.getParam().password() || (pwd = passwords.get(pwdname = opt.getName())) == null) continue;
                options.set(pwdname, pwd);
            }
        }
        return options;
    }

    @Override
    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    ActionReport executeCommand(String command, String ... args) throws CommandException {
        ParameterMap commandParams = this.getParameters(command, args);
        ActionReport actionReport = this.createActionReport();
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(command, actionReport, this.embeddedSystemAdministrator.getSubject(), false);
        inv.parameters(commandParams).execute();
        return actionReport;
    }

    private CommandResult convert(final ActionReport actionReport) {
        return new CommandResult(){

            @Override
            public CommandResult.ExitStatus getExitStatus() {
                ActionReport.ExitCode actionExitCode = actionReport.getActionExitCode();
                switch (actionExitCode) {
                    case SUCCESS: {
                        return CommandResult.ExitStatus.SUCCESS;
                    }
                    case WARNING: {
                        return CommandResult.ExitStatus.WARNING;
                    }
                    case FAILURE: {
                        return CommandResult.ExitStatus.FAILURE;
                    }
                }
                throw new RuntimeException("Unknown exit code: " + (Object)((Object)actionExitCode));
            }

            @Override
            public String getOutput() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    actionReport.writeReport(os);
                    String string = os.toString();
                    return string;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }

            @Override
            public Throwable getFailureCause() {
                return actionReport.getFailureCause();
            }
        };
    }

    private CommandResult convert(final Exception e) {
        return new CommandResult(){

            @Override
            public CommandResult.ExitStatus getExitStatus() {
                return CommandResult.ExitStatus.FAILURE;
            }

            @Override
            public String getOutput() {
                return "Exception while executing command.";
            }

            @Override
            public Throwable getFailureCause() {
                return e;
            }
        };
    }

    ActionReport createActionReport() {
        return this.habitat.getService(ActionReport.class, "plain", new Annotation[0]);
    }

    CommandRunner getCommandRunner() {
        return this.commandRunner;
    }
}

