/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class DirectoryClassLoader
extends URLClassLoader {
    private static final LocalStringsImpl strings = new LocalStringsImpl(DirectoryClassLoader.class);

    public DirectoryClassLoader(String dir, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(new File(dir)), parent);
    }

    public DirectoryClassLoader(Set<File> jarsAndDirs, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(jarsAndDirs), parent);
    }

    public DirectoryClassLoader(File dir, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(dir), parent);
    }

    private static URL[] getJars(Set<File> jarsAndDirs) throws IOException {
        if (jarsAndDirs == null) {
            throw new IOException(strings.get("DirError", ""));
        }
        ArrayList<URL> result = new ArrayList<URL>();
        for (File jd : jarsAndDirs) {
            if (jd.isDirectory()) {
                result.addAll(Arrays.asList(DirectoryClassLoader.getJars(jd)));
                continue;
            }
            result.add(jd.toURI().toURL());
        }
        return result.toArray(new URL[result.size()]);
    }

    private static URL[] getJars(File dir) throws IOException {
        File[] fjars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (fjars == null) {
            throw new IOException(strings.get("DirError", dir));
        }
        URL[] jars = new URL[fjars.length];
        for (int i = 0; i < fjars.length; ++i) {
            jars[i] = fjars[i].toURI().toURL();
        }
        return jars;
    }
}

