/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;

public final class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private static final String className = ItemCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(ItemCheckpointAlgorithm.class.getPackage().getName());
    long itemsRead = 0L;
    protected int itemCount;
    protected int timeLimitSeconds;
    long checkpointBeginTime = 0L;

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public void setTimeLimitSeconds(int timeLimitSeconds) {
        this.timeLimitSeconds = timeLimitSeconds;
    }

    @Override
    public void endCheckpoint() throws Exception {
    }

    public boolean isReadyToCheckpointItem() {
        boolean itemready;
        boolean bl = itemready = this.itemsRead >= (long)this.itemCount;
        if (itemready) {
            logger.fine("ITEMCHKPT: item checkpoint hit");
            if (logger.isLoggable(Level.FINER)) {
                long millis = new Date().getTime() - this.checkpointBeginTime;
                if (millis > 0L) {
                    String rate = Integer.valueOf(Long.valueOf(this.itemsRead * 1000L / millis).intValue()).toString();
                    logger.finer(" - true [itemsReadAndProcessed/second " + rate + "]");
                } else {
                    logger.finer(" - true [itemsReadAndProcessed " + this.itemsRead + "]");
                }
            }
        }
        return itemready;
    }

    public boolean isReadyToCheckpointTime() {
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        boolean timeready = false;
        Date curDate = new Date();
        long curts = curDate.getTime();
        long curdiff = curts - this.checkpointBeginTime;
        int diff = (int)curdiff / 1000;
        if (diff >= this.timeLimitSeconds) {
            logger.fine("ITEMTIMECHKPT: time checkpoint hit");
            timeready = true;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Num of itemsReadAndProcessed=" + this.itemsRead + " at a rate=" + this.itemsRead / (long)diff + " itemsReadAndProcessed/sec");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method, timeready);
        }
        return timeready;
    }

    @Override
    public boolean isReadyToCheckpoint() {
        ++this.itemsRead;
        if (this.isReadyToCheckpointItem()) {
            return true;
        }
        return this.timeLimitSeconds > 0 && this.isReadyToCheckpointTime();
    }

    @Override
    public void beginCheckpoint() throws Exception {
        Date date = new Date();
        this.checkpointBeginTime = date.getTime();
        this.itemsRead = 0L;
    }

    @Override
    public int checkpointTimeout() throws Exception {
        return 0;
    }
}

