/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationValue;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class InvocationFuture<E>
extends AbstractInvocationFuture<E> {
    volatile boolean interrupted;
    final Invocation invocation;
    private final boolean deserialize;

    InvocationFuture(Invocation invocation, boolean deserialize) {
        super(invocation.context.asyncExecutor, invocation.context.logger);
        this.invocation = invocation;
        this.deserialize = deserialize;
    }

    @Override
    protected String invocationToString() {
        return this.invocation.toString();
    }

    @Override
    protected TimeoutException newTimeoutException(long timeout, TimeUnit unit) {
        return new TimeoutException(this.invocation.op.getClass().getSimpleName() + " failed to complete within " + timeout + " " + (Object)((Object)unit) + ". " + this.invocation);
    }

    @Override
    protected void onInterruptDetected() {
        this.interrupted = true;
    }

    @Override
    protected E resolveAndThrow(Object unresolved) throws ExecutionException, InterruptedException {
        Object value = this.resolve(unresolved);
        if (value == null || !(value instanceof Throwable)) {
            return (E)value;
        }
        if (value instanceof ExecutionException) {
            throw (ExecutionException)value;
        }
        if (value instanceof InterruptedException) {
            throw (InterruptedException)value;
        }
        if (value instanceof Error) {
            throw (Error)value;
        }
        throw new ExecutionException((Throwable)value);
    }

    @Override
    protected Object resolve(Object unresolved) {
        if (unresolved == null) {
            return null;
        }
        if (unresolved == InvocationValue.INTERRUPTED) {
            return new InterruptedException(this.invocation.op.getClass().getSimpleName() + " was interrupted. " + this.invocation);
        }
        if (unresolved == InvocationValue.CALL_TIMEOUT) {
            return this.newOperationTimeoutException(false);
        }
        if (unresolved == InvocationValue.HEARTBEAT_TIMEOUT) {
            return this.newOperationTimeoutException(true);
        }
        Object value = unresolved;
        if (this.deserialize && value instanceof Data && (value = this.invocation.context.serializationService.toObject(value)) == null) {
            return null;
        }
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            ExceptionUtil.fixAsyncStackTrace((Throwable)value, Thread.currentThread().getStackTrace());
            return throwable;
        }
        return value;
    }

    private Object newOperationTimeoutException(boolean heartbeatTimeout) {
        StringBuilder sb = new StringBuilder();
        if (heartbeatTimeout) {
            sb.append(this.invocation.op.getClass().getSimpleName()).append(" invocation failed to complete due to operation-heartbeat-timeout. ");
            sb.append("Current time: ").append(StringUtil.timeToString(System.currentTimeMillis())).append(". ");
            sb.append("Total elapsed time: ").append(System.currentTimeMillis() - this.invocation.firstInvocationTimeMillis).append(" ms. ");
            long lastHeartbeatMillis = this.invocation.lastHeartbeatMillis;
            sb.append("Last operation heartbeat: ");
            InvocationFuture.appendHeartbeat(sb, lastHeartbeatMillis);
            long lastHeartbeatFromMemberMillis = this.invocation.context.invocationMonitor.getLastMemberHeartbeatMillis(this.invocation.invTarget);
            sb.append("Last operation heartbeat from member: ");
            InvocationFuture.appendHeartbeat(sb, lastHeartbeatFromMemberMillis);
        } else {
            sb.append(this.invocation.op.getClass().getSimpleName()).append(" got rejected before execution due to not starting within the operation-call-timeout of: ").append(this.invocation.callTimeoutMillis).append(" ms. ");
            sb.append("Current time: ").append(StringUtil.timeToString(System.currentTimeMillis())).append(". ");
            sb.append("Total elapsed time: ").append(System.currentTimeMillis() - this.invocation.firstInvocationTimeMillis).append(" ms. ");
        }
        sb.append(this.invocation);
        String msg = sb.toString();
        return new ExecutionException(msg, new OperationTimeoutException(msg));
    }

    private static void appendHeartbeat(StringBuilder sb, long lastHeartbeatMillis) {
        if (lastHeartbeatMillis == 0L) {
            sb.append("never. ");
        } else {
            sb.append(StringUtil.timeToString(lastHeartbeatMillis)).append(". ");
        }
    }
}

