/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.internal.util.ThreadLocalRandom;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.impl.CallIdSequence;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;

class BackpressureRegulator {
    static final float RANGE = 0.25f;
    private static final int INTS_PER_CACHE_LINE = 16;
    private final int[] syncDelays;
    private final boolean enabled;
    private final boolean disabled;
    private final int syncWindow;
    private final int partitionCount;
    private final int maxConcurrentInvocations;
    private final int backoffTimeoutMs;

    BackpressureRegulator(HazelcastProperties properties, ILogger logger2) {
        this.enabled = properties.getBoolean(GroupProperty.BACKPRESSURE_ENABLED);
        this.disabled = !this.enabled;
        this.partitionCount = properties.getInteger(GroupProperty.PARTITION_COUNT);
        this.syncWindow = this.getSyncWindow(properties);
        this.maxConcurrentInvocations = this.getMaxConcurrentInvocations(properties);
        this.backoffTimeoutMs = this.getBackoffTimeoutMs(properties);
        this.syncDelays = new int[16 * this.partitionCount];
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            this.syncDelays[partitionId * 16] = this.randomSyncDelay();
        }
        if (this.enabled) {
            logger2.info("Backpressure is enabled, maxConcurrentInvocations:" + this.maxConcurrentInvocations + ", syncWindow: " + this.syncWindow);
        } else {
            logger2.info("Backpressure is disabled");
        }
    }

    private int getSyncWindow(HazelcastProperties props) {
        int syncWindow = props.getInteger(GroupProperty.BACKPRESSURE_SYNCWINDOW);
        if (this.enabled && syncWindow <= 0) {
            throw new IllegalArgumentException("Can't have '" + GroupProperty.BACKPRESSURE_SYNCWINDOW + "' with a value smaller than 1");
        }
        return syncWindow;
    }

    private int getBackoffTimeoutMs(HazelcastProperties props) {
        int backoffTimeoutMs = (int)props.getMillis(GroupProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS);
        if (this.enabled && backoffTimeoutMs < 0) {
            throw new IllegalArgumentException("Can't have '" + GroupProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS + "' with a value smaller than 0");
        }
        return backoffTimeoutMs;
    }

    private int getMaxConcurrentInvocations(HazelcastProperties props) {
        int invocationsPerPartition = props.getInteger(GroupProperty.BACKPRESSURE_MAX_CONCURRENT_INVOCATIONS_PER_PARTITION);
        if (invocationsPerPartition < 1) {
            throw new IllegalArgumentException("Can't have '" + GroupProperty.BACKPRESSURE_MAX_CONCURRENT_INVOCATIONS_PER_PARTITION + "' with a value smaller than 1");
        }
        return (this.partitionCount + 1) * invocationsPerPartition;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    int syncDelay(Operation op) {
        return this.syncDelays[op.getPartitionId() * 16];
    }

    int getMaxConcurrentInvocations() {
        if (this.enabled) {
            return this.maxConcurrentInvocations;
        }
        return Integer.MAX_VALUE;
    }

    CallIdSequence newCallIdSequence() {
        if (this.enabled) {
            return new CallIdSequence.CallIdSequenceWithBackpressure(this.maxConcurrentInvocations, this.backoffTimeoutMs);
        }
        return new CallIdSequence.CallIdSequenceWithoutBackpressure();
    }

    boolean isSyncForced(BackupAwareOperation backupAwareOp) {
        if (this.disabled) {
            return false;
        }
        if (backupAwareOp.getPartitionId() < 0) {
            throw new IllegalArgumentException("A BackupAwareOperation can't have a negative partitionId, " + backupAwareOp);
        }
        if (backupAwareOp.getAsyncBackupCount() == 0) {
            return false;
        }
        Operation op = (Operation)((Object)backupAwareOp);
        if (op.isUrgent()) {
            return false;
        }
        int index = op.getPartitionId() * 16;
        int oldSyncDelay = this.syncDelays[index];
        if (oldSyncDelay == 1) {
            int newSyncDelay;
            this.syncDelays[index] = newSyncDelay = this.randomSyncDelay();
            return true;
        }
        this.syncDelays[index] = oldSyncDelay - 1;
        return false;
    }

    private int randomSyncDelay() {
        if (this.syncWindow == 1) {
            return 1;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int randomSyncWindow = Math.round(0.75f * (float)this.syncWindow + (float)random.nextInt(Math.round(0.5f * (float)this.syncWindow)));
        return Math.max(1, randomSyncWindow);
    }
}

