/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.spinning.SpinningSocketWriter;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SpinningOutputThread
extends Thread {
    private static final SocketWriters SHUTDOWN = new SocketWriters();
    private static final AtomicReferenceFieldUpdater<SpinningOutputThread, SocketWriters> CONNECTION_HANDLERS = AtomicReferenceFieldUpdater.newUpdater(SpinningOutputThread.class, SocketWriters.class, "socketWriters");
    private final ILogger logger;
    private volatile SocketWriters socketWriters;

    public SpinningOutputThread(HazelcastThreadGroup threadGroup, ILogger logger2) {
        super(threadGroup.getInternalThreadGroup(), "out-thread");
        this.logger = logger2;
        this.socketWriters = new SocketWriters();
    }

    public void addConnection(TcpIpConnection connection) {
        SpinningSocketWriter[] newWriters;
        SocketWriters update;
        SocketWriters current;
        SpinningSocketWriter writer = (SpinningSocketWriter)connection.getSocketWriter();
        do {
            if ((current = this.socketWriters) == SHUTDOWN) {
                return;
            }
            int length = current.writers.length;
            newWriters = new SpinningSocketWriter[length + 1];
            System.arraycopy(current.writers, 0, newWriters, 0, length);
            newWriters[length] = writer;
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketWriters(newWriters)));
    }

    public void removeConnection(TcpIpConnection connection) {
        SpinningSocketWriter[] newWriters;
        SocketWriters update;
        SocketWriters current;
        SpinningSocketWriter writeHandlers = (SpinningSocketWriter)connection.getSocketWriter();
        do {
            if ((current = this.socketWriters) == SHUTDOWN) {
                return;
            }
            int indexOf = current.indexOf(writeHandlers);
            if (indexOf == -1) {
                return;
            }
            int length = current.writers.length;
            newWriters = new SpinningSocketWriter[length - 1];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                if (sourceIndex == indexOf) continue;
                newWriters[destIndex] = current.writers[sourceIndex];
                ++destIndex;
            }
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketWriters(newWriters)));
    }

    public void shutdown() {
        this.socketWriters = SHUTDOWN;
        this.interrupt();
    }

    @Override
    public void run() {
        SocketWriters handlers;
        block2: while ((handlers = this.socketWriters) != SHUTDOWN) {
            SpinningSocketWriter[] arr$ = handlers.writers;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) continue block2;
                SpinningSocketWriter writer = arr$[i$];
                try {
                    writer.write();
                }
                catch (Throwable t) {
                    writer.onFailure(t);
                }
                ++i$;
            }
            break;
        }
        return;
    }

    static class SocketWriters {
        final SpinningSocketWriter[] writers;

        public SocketWriters() {
            this(new SpinningSocketWriter[0]);
        }

        public SocketWriters(SpinningSocketWriter[] writers) {
            this.writers = writers;
        }

        public int indexOf(SpinningSocketWriter handler) {
            for (int k = 0; k < this.writers.length; ++k) {
                if (this.writers[k] != handler) continue;
                return k;
            }
            return -1;
        }
    }
}

