/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.spinning.SpinningSocketReader;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SpinningInputThread
extends Thread {
    private static final SocketReaders SHUTDOWN = new SocketReaders();
    private static final AtomicReferenceFieldUpdater<SpinningInputThread, SocketReaders> CONNECTION_HANDLERS = AtomicReferenceFieldUpdater.newUpdater(SpinningInputThread.class, SocketReaders.class, "socketReaders");
    private final ILogger logger;
    private volatile SocketReaders socketReaders;

    public SpinningInputThread(HazelcastThreadGroup threadGroup, ILogger logger2) {
        super(threadGroup.getInternalThreadGroup(), "in-thread");
        this.logger = logger2;
        this.socketReaders = new SocketReaders();
    }

    public void addConnection(TcpIpConnection connection) {
        SpinningSocketReader[] newReaders;
        SocketReaders update;
        SocketReaders current;
        SpinningSocketReader reader = (SpinningSocketReader)connection.getSocketReader();
        do {
            if ((current = this.socketReaders) == SHUTDOWN) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningSocketReader[length + 1];
            System.arraycopy(current.readers, 0, newReaders, 0, length);
            newReaders[length] = reader;
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketReaders(newReaders)));
    }

    public void removeConnection(TcpIpConnection connection) {
        SpinningSocketReader[] newReaders;
        SocketReaders update;
        SocketReaders current;
        SpinningSocketReader reader = (SpinningSocketReader)connection.getSocketReader();
        do {
            if ((current = this.socketReaders) == SHUTDOWN) {
                return;
            }
            int indexOf = current.indexOf(reader);
            if (indexOf == -1) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningSocketReader[length - 1];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                if (sourceIndex == indexOf) continue;
                newReaders[destIndex] = current.readers[sourceIndex];
                ++destIndex;
            }
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketReaders(newReaders)));
    }

    public void shutdown() {
        this.socketReaders = SHUTDOWN;
        this.interrupt();
    }

    @Override
    public void run() {
        SocketReaders handlers;
        block2: while ((handlers = this.socketReaders) != SHUTDOWN) {
            SpinningSocketReader[] arr$ = handlers.readers;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) continue block2;
                SpinningSocketReader reader = arr$[i$];
                try {
                    reader.read();
                }
                catch (Throwable t) {
                    reader.onFailure(t);
                }
                ++i$;
            }
            break;
        }
        return;
    }

    static class SocketReaders {
        final SpinningSocketReader[] readers;

        public SocketReaders() {
            this(new SpinningSocketReader[0]);
        }

        public SocketReaders(SpinningSocketReader[] readers) {
            this.readers = readers;
        }

        public int indexOf(SpinningSocketReader readHandler) {
            for (int k = 0; k < this.readers.length; ++k) {
                if (this.readers[k] != readHandler) continue;
                return k;
            }
            return -1;
        }
    }
}

