/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.AbstractEvictableRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreLoader;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;

public class DefaultRecordStore
extends AbstractEvictableRecordStore {
    protected final ILogger logger;
    protected final RecordStoreLoader recordStoreLoader;
    protected final MapKeyLoader keyLoader;
    protected final Collection<Future> loadingFutures = new ConcurrentLinkedQueue<Future>();
    private boolean loadedOnCreate;
    private boolean loadedOnPreMigration;

    public DefaultRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger2) {
        super(mapContainer, partitionId);
        this.logger = logger2;
        this.keyLoader = keyLoader;
        this.recordStoreLoader = this.createRecordStoreLoader(this.mapStoreContext);
        this.loadedOnCreate = false;
    }

    @Override
    public void startLoading() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("StartLoading invoked " + this.getStateMessage());
        }
        if (this.mapStoreContext.isMapLoader() && !this.loadedOnCreate) {
            if (!this.loadedOnPreMigration) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Triggering load " + this.getStateMessage());
                }
                this.loadedOnCreate = true;
                this.loadingFutures.add(this.keyLoader.startInitialLoad(this.mapStoreContext, this.partitionId));
            } else {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Promoting to loaded on migration " + this.getStateMessage());
                }
                this.keyLoader.promoteToLoadedOnMigration();
            }
        }
    }

    @Override
    public void setPreMigrationLoadedStatus(boolean loaded) {
        this.loadedOnPreMigration = loaded;
    }

    @Override
    public boolean isLoaded() {
        return FutureUtil.allDone(this.loadingFutures);
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("loadAll invoked " + this.getStateMessage());
        }
        this.logger.info("Starting to load all keys for map " + this.name + " on partitionId=" + this.partitionId);
        Future<?> loadingKeysFuture = this.keyLoader.startLoading(this.mapStoreContext, replaceExistingValues);
        this.loadingFutures.add(loadingKeysFuture);
    }

    @Override
    public void loadAllFromStore(List<Data> keys) {
        if (!keys.isEmpty()) {
            Future<?> f = this.recordStoreLoader.loadValues(keys);
            this.loadingFutures.add(f);
        }
        this.keyLoader.trackLoading(false, null);
    }

    @Override
    public void updateLoadStatus(boolean lastBatch, Throwable exception) {
        this.keyLoader.trackLoading(lastBatch, exception);
        if (lastBatch) {
            this.logger.finest("Completed loading map " + this.name + " on partitionId=" + this.partitionId);
        }
    }

    @Override
    public void maybeDoInitialLoad() {
        if (this.keyLoader.shouldDoInitialLoad()) {
            this.loadAll(false);
        }
    }

    @Override
    public void destroy() {
        this.clearPartition(false);
        this.storage.destroy(false);
    }

    @Override
    public void onKeyLoad(ExecutionCallback<Boolean> callback) {
        this.keyLoader.onKeyLoad(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIfLoaded() {
        if (this.loadingFutures.isEmpty()) {
            return;
        }
        if (this.isLoaded()) {
            List<Future> doneFutures = null;
            try {
                doneFutures = FutureUtil.getAllDone(this.loadingFutures);
                FutureUtil.checkAllDone(doneFutures);
            }
            catch (Exception e) {
                this.logger.severe("Exception while loading map " + this.name, e);
                ExceptionUtil.rethrow(e);
            }
            finally {
                this.loadingFutures.removeAll(doneFutures);
            }
        } else {
            this.keyLoader.triggerLoadingWithDelay();
            throw new RetryableHazelcastException("Map " + this.getName() + " is still loading data from external store");
        }
    }

    @Override
    public long softFlush() {
        this.updateStoreStats();
        return this.mapDataStore.softFlush();
    }

    protected void flush(Collection<Record> recordsToBeFlushed, boolean backup) {
        for (Record record : recordsToBeFlushed) {
            this.mapDataStore.flush(record.getKey(), record.getValue(), backup);
        }
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.storage.get(key);
    }

    @Override
    public void putRecord(Data key, Record record) {
        this.markRecordStoreExpirable(record.getTtl());
        this.storage.put(key, record);
        this.updateStatsOnPut(record.getHits());
    }

    @Override
    public Record putBackup(Data key, Object value) {
        return this.putBackup(key, value, -1L, false);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl, boolean putTransient) {
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            record = this.createRecord(value, ttl, now);
            this.storage.put(key, record);
        } else {
            this.updateRecord(key, record, value, now);
        }
        if (putTransient) {
            this.mapDataStore.addTransient(key, now);
        } else {
            this.mapDataStore.addBackup(key, value, now);
        }
        return record;
    }

    @Override
    public Iterator<Record> iterator() {
        return new AbstractEvictableRecordStore.ReadOnlyRecordIterator(this.storage.values());
    }

    @Override
    public Iterator<Record> iterator(long now, boolean backup) {
        return new AbstractEvictableRecordStore.ReadOnlyRecordIterator(this.storage.values(), now, backup);
    }

    @Override
    public MapKeysWithCursor fetchKeys(int tableIndex, int size) {
        return this.storage.fetchKeys(tableIndex, size);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(int tableIndex, int size) {
        return this.storage.fetchEntries(tableIndex, size, this.serializationService);
    }

    @Override
    public Iterator<Record> loadAwareIterator(long now, boolean backup) {
        this.checkIfLoaded();
        return this.iterator(now, backup);
    }

    @Override
    public void clearPartition(boolean onShutdown) {
        Indexes indexes;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
        if ((indexes = this.mapContainer.getIndexes()).hasIndex()) {
            for (Record record : this.storage.values()) {
                Data key = record.getKey();
                Object value = Records.getValueOrCachedValue(record, this.serializationService);
                indexes.removeEntryIndex(key, value);
            }
        }
        this.mapDataStore.reset();
        if (onShutdown) {
            boolean shouldClear;
            NativeMemoryConfig nativeMemoryConfig = nodeEngine.getConfig().getNativeMemoryConfig();
            boolean bl = shouldClear = nativeMemoryConfig != null && nativeMemoryConfig.getAllocatorType() != NativeMemoryConfig.MemoryAllocatorType.POOLED;
            if (shouldClear) {
                this.storage.clear(true);
            }
            this.storage.destroy(true);
        } else {
            this.storage.clear(false);
        }
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.storage.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        Collection records = this.storage.values();
        for (Record record : records) {
            if (this.getOrNullIfExpired(record, now, false) == null || !this.recordFactory.isEquals(value, record.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long referenceId, long ttl, boolean blockReads) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, referenceId, ttl, blockReads);
    }

    @Override
    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId, long referenceId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId, referenceId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean isTransactionallyLocked(Data key) {
        return this.lockStore != null && this.lockStore.shouldBlockReads(key);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Record loadRecordOrNull(Data key, boolean backup) {
        Record record = null;
        Object value = this.mapDataStore.load(key);
        if (value != null) {
            record = this.createRecord(value, -1L, this.getNow());
            this.storage.put(key, record);
            if (!backup) {
                this.saveIndex(record, null);
            }
            this.evictEntries(key);
        }
        return record;
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        long now = this.getNow();
        Collection records = this.storage.values();
        HashSet<Data> keySet = Collections.EMPTY_SET;
        for (Record record : records) {
            Data key = record.getKey();
            if ((record = this.getOrNullIfExpired(record, now, false)) == null) continue;
            if (keySet == Collections.EMPTY_SET) {
                keySet = new HashSet<Data>();
            }
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public int clear() {
        this.checkIfLoaded();
        Collection<Record> clearableRecords = this.getNotLockedRecords();
        List<Data> keys = this.getKeysFromRecords(clearableRecords);
        this.mapDataStore.removeAll(keys);
        this.mapDataStore.reset();
        this.removeIndex(clearableRecords);
        return this.removeRecords(clearableRecords);
    }

    protected List<Data> getKeysFromRecords(Collection<Record> clearableRecords) {
        ArrayList<Data> keys = new ArrayList<Data>(clearableRecords.size());
        for (Record clearableRecord : clearableRecords) {
            keys.add(clearableRecord.getKey());
        }
        return keys;
    }

    protected int removeRecords(Collection<Record> recordsToRemove) {
        if (CollectionUtil.isEmpty(recordsToRemove)) {
            return 0;
        }
        int removalSize = recordsToRemove.size();
        Iterator<Record> iterator = recordsToRemove.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            this.storage.removeRecord(record);
            this.updateStatsOnRemove(record.getHits());
            iterator.remove();
        }
        return removalSize;
    }

    protected Collection<Record> getNotLockedRecords() {
        Set<Data> lockedKeySet;
        Set<Data> set = lockedKeySet = this.lockStore == null ? null : this.lockStore.getLockedKeys();
        if (CollectionUtil.isEmpty(lockedKeySet)) {
            return this.storage.values();
        }
        int notLockedKeyCount = this.storage.size() - lockedKeySet.size();
        if (notLockedKeyCount <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Record> notLockedRecords = new ArrayList<Record>(notLockedKeyCount);
        Collection records = this.storage.values();
        for (Record record : records) {
            if (lockedKeySet.contains(record.getKey())) continue;
            notLockedRecords.add(record);
        }
        return notLockedRecords;
    }

    @Override
    public void reset() {
        this.mapDataStore.reset();
        this.storage.clear(false);
        this.resetStats();
    }

    @Override
    public Object evict(Data key, boolean backup) {
        Record record = (Record)this.storage.get(key);
        Object value = null;
        if (record != null) {
            value = record.getValue();
            this.mapDataStore.flush(key, value, backup);
            this.removeIndex(record);
            this.storage.removeRecord(record);
            this.updateStatsOnRemove(record.getHits());
            if (!backup) {
                this.mapServiceContext.interceptRemove(this.name, value);
            }
        }
        return value;
    }

    @Override
    public int evictAll(boolean backup) {
        this.checkIfLoaded();
        Collection<Record> evictableRecords = this.getNotLockedRecords();
        this.flush(evictableRecords, backup);
        this.removeIndex(evictableRecords);
        return this.removeRecords(evictableRecords);
    }

    @Override
    public void removeBackup(Data key) {
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            return;
        }
        this.storage.removeRecord(record);
        this.updateStatsOnRemove(record.getHits());
        this.mapDataStore.removeBackup(key, now);
    }

    @Override
    public Object remove(Data key) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                this.mapDataStore.remove(key, now);
            }
        } else {
            oldValue = this.removeRecord(key, record, now);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Data key, Object testValue) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        boolean removed = false;
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.recordFactory.isEquals(testValue, oldValue)) {
            this.mapServiceContext.interceptRemove(this.name, oldValue);
            this.removeIndex(record);
            this.mapDataStore.remove(key, now);
            this.onStore(record);
            this.storage.removeRecord(record);
            this.updateStatsOnRemove(record.getHits());
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean delete(Data key) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record != null) {
            return this.removeRecord(key, record, now) != null;
        }
        this.mapDataStore.remove(key, now);
        return false;
    }

    @Override
    public Object get(Data key, boolean backup) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, backup);
        if (record == null) {
            record = this.loadRecordOrNull(key, backup);
        } else {
            this.accessRecord(record, now);
        }
        Object value = record == null ? null : (Object)record.getValue();
        value = this.mapServiceContext.interceptGet(this.name, value);
        return value;
    }

    @Override
    public Data readBackupData(Data key) {
        long now = this.getNow();
        Record record = this.getRecord(key);
        if (record == null) {
            return null;
        }
        boolean expired = this.isExpired(record, now, false);
        if (expired) {
            return null;
        }
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Object value = record.getValue();
        mapServiceContext.interceptAfterGet(this.name, value);
        return mapServiceContext.toData(value);
    }

    @Override
    public MapEntries getAll(Set<Data> keys) {
        this.checkIfLoaded();
        long now = this.getNow();
        MapEntries mapEntries = new MapEntries(keys.size());
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Record record = this.getRecordOrNull(key, now, false);
            if (record == null) continue;
            this.addMapEntrySet(key, record.getValue(), mapEntries);
            this.accessRecord(record, now);
            iterator.remove();
        }
        Map<Object, Object> loadedEntries = this.loadEntries(keys);
        this.addMapEntrySet(loadedEntries, mapEntries);
        return mapEntries;
    }

    protected Map<Data, Object> loadEntries(Set<Data> keys) {
        Map loadedEntries = this.mapDataStore.loadAll(keys);
        if (loadedEntries == null || loadedEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Data, Object> resultMap = MapUtil.createHashMap(loadedEntries.size());
        Set entrySet = loadedEntries.entrySet();
        Iterator i$ = entrySet.iterator();
        while (i$.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = i$.next();
            Data key = this.toData(entry.getKey());
            Object value = entry.getValue();
            resultMap.put(key, value);
            this.putFromLoad(key, value);
        }
        return resultMap;
    }

    protected void addMapEntrySet(Object key, Object value, MapEntries mapEntries) {
        if (key == null || value == null) {
            return;
        }
        value = this.mapServiceContext.interceptGet(this.name, value);
        Data dataKey = this.mapServiceContext.toData(key);
        Data dataValue = this.mapServiceContext.toData(value);
        mapEntries.add(dataKey, dataValue);
    }

    protected void addMapEntrySet(Map<Object, Object> entries, MapEntries mapEntries) {
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            this.addMapEntrySet(entry.getKey(), entry.getValue(), mapEntries);
        }
    }

    @Override
    public boolean containsKey(Data key) {
        boolean contains;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            record = this.loadRecordOrNull(key, false);
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record, now);
        }
        return contains;
    }

    @Override
    public Object put(Data key, Object value, long ttl) {
        return this.putInternal(key, value, ttl, true);
    }

    protected Object putInternal(Data key, Object value, long ttl, boolean loadFromStore) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = record == null ? (loadFromStore ? this.mapDataStore.load(key) : null) : record.getValue();
        value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
        value = this.mapDataStore.add(key, value, now);
        this.onStore(record);
        if (record == null) {
            record = this.createRecord(value, ttl, now);
            this.storage.put(key, record);
        } else {
            this.updateRecord(key, record, value, now);
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record, oldValue);
        return oldValue;
    }

    @Override
    public boolean merge(Data key, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Object newValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        mergingEntry = EntryViews.convertToLazyEntryView(mergingEntry, this.serializationService, mergePolicy);
        Object oldValue = null;
        if (record == null) {
            Object notExistingKey = this.mapServiceContext.toObject(key);
            EntryView nullEntryView = EntryViews.createNullEntryView(notExistingKey);
            newValue = mergePolicy.merge(this.name, mergingEntry, nullEntryView);
            if (newValue == null) {
                return false;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            record = this.createRecord(newValue, -1L, now);
            this.mergeRecordExpiration(record, mergingEntry);
            this.storage.put(key, record);
        } else {
            oldValue = record.getValue();
            EntryView existingEntry = EntryViews.createLazyEntryView(record.getKey(), record.getValue(), record, this.serializationService, mergePolicy);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.removeIndex(record);
                this.mapDataStore.remove(key, now);
                this.onStore(record);
                this.storage.removeRecord(record);
                this.updateStatsOnRemove(record.getHits());
                return true;
            }
            if (newValue == mergingEntry.getValue()) {
                this.mergeRecordExpiration(record, mergingEntry);
            }
            if (this.recordFactory.isEquals(newValue, oldValue)) {
                return true;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            this.onStore(record);
            this.storage.updateRecordValue(key, record, newValue);
        }
        this.saveIndex(record, oldValue);
        return newValue != null;
    }

    @Override
    public Object replace(Data key, Object update) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null || record.getValue() == null) {
            return null;
        }
        Object oldValue = record.getValue();
        update = this.mapServiceContext.interceptPut(this.name, oldValue, update);
        update = this.mapDataStore.add(key, update, now);
        this.onStore(record);
        this.updateRecord(key, record, update, now);
        this.saveIndex(record, oldValue);
        return oldValue;
    }

    @Override
    public boolean replace(Data key, Object expect, Object update) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            return false;
        }
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Object current = record.getValue();
        String mapName = this.name;
        if (!this.recordFactory.isEquals(expect, current)) {
            return false;
        }
        update = mapServiceContext.interceptPut(mapName, current, update);
        update = this.mapDataStore.add(key, update, now);
        this.onStore(record);
        this.updateRecord(key, record, update, now);
        this.saveIndex(record, current);
        return true;
    }

    @Override
    public void putTransient(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(value, ttl, now);
            this.storage.put(key, record);
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            this.updateRecord(key, record, value, now);
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record, oldValue);
        this.mapDataStore.addTransient(key, now);
    }

    @Override
    public Object putFromLoad(Data key, Object value) {
        return this.putFromLoadInternal(key, value, -1L, false);
    }

    @Override
    public Object putFromLoadBackup(Data key, Object value) {
        return this.putFromLoadInternal(key, value, -1L, true);
    }

    @Override
    public Object putFromLoad(Data key, Object value, long ttl) {
        return this.putFromLoadInternal(key, value, ttl, false);
    }

    private Object putFromLoadInternal(Data key, Object value, long ttl, boolean backup) {
        if (!this.isKeyAndValueLoadable(key, value)) {
            return null;
        }
        long now = this.getNow();
        if (this.shouldEvict()) {
            return null;
        }
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(value, ttl, now);
            this.storage.put(key, record);
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            this.updateRecord(key, record, value, now);
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        if (!backup) {
            this.saveIndex(record, oldValue);
        }
        return oldValue;
    }

    protected boolean isKeyAndValueLoadable(Data key, Object value) {
        if (key == null) {
            this.logger.warning("Found an attempt to load a null key from map-store, ignoring it.");
            return false;
        }
        if (value == null) {
            this.logger.warning("Found an attempt to load a null value from map-store, ignoring it.");
            return false;
        }
        return true;
    }

    @Override
    public boolean set(Data dataKey, Object value, long ttl) {
        Object oldValue = this.putInternal(dataKey, value, ttl, false);
        return oldValue == null;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                record = this.createRecord(oldValue, -1L, now);
                this.storage.put(key, record);
            }
        } else {
            this.accessRecord(record, now);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            record = this.createRecord(value, ttl, now);
            this.storage.put(key, record);
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record, oldValue);
        return oldValue;
    }

    @Override
    public MapDataStore<Data, Object> getMapDataStore() {
        return this.mapDataStore;
    }

    protected Object removeRecord(Data key, Record record, long now) {
        Object oldValue = record.getValue();
        if ((oldValue = this.mapServiceContext.interceptRemove(this.name, oldValue)) != null) {
            this.removeIndex(record);
            this.mapDataStore.remove(key, now);
            this.onStore(record);
        }
        this.storage.removeRecord(record);
        this.updateStatsOnRemove(record.getHits());
        return oldValue;
    }

    @Override
    public Record getRecordOrNull(Data key) {
        long now = this.getNow();
        return this.getRecordOrNull(key, now, false);
    }

    protected Record getRecordOrNull(Data key, long now, boolean backup) {
        Record record = (Record)this.storage.get(key);
        if (record == null) {
            return null;
        }
        return this.getOrNullIfExpired(record, now, backup);
    }

    protected void onStore(Record record) {
        if (record == null || this.mapDataStore == MapDataStores.EMPTY_MAP_DATA_STORE) {
            return;
        }
        record.onStore();
    }

    private void updateStoreStats() {
        if (!(this.mapDataStore instanceof WriteBehindStore) || !this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            return;
        }
        long now = Clock.currentTimeMillis();
        WriteBehindQueue<DelayedEntry> writeBehindQueue = ((WriteBehindStore)this.mapDataStore).getWriteBehindQueue();
        List<DelayedEntry> delayedEntries = writeBehindQueue.asList();
        for (DelayedEntry delayedEntry : delayedEntries) {
            Record record = this.getRecordOrNull(this.toData(delayedEntry.getKey()), now, false);
            this.onStore(record);
        }
    }

    private String getStateMessage() {
        return "on partitionId=" + this.partitionId + " on " + this.mapServiceContext.getNodeEngine().getThisAddress() + " loadedOnCreate=" + this.loadedOnCreate + " loadedOnPreMigration=" + this.loadedOnPreMigration + " isLoaded=" + this.isLoaded();
    }
}

