/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;

public class ShutdownRequestOperation
extends Operation
implements MigrationCycleOperation {
    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger2 = this.getLogger();
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        if (clusterService.isMaster()) {
            if (clusterService.getMember(caller) != null) {
                if (logger2.isFinestEnabled()) {
                    logger2.finest("Received shutdown request from " + caller);
                }
                partitionService.onShutdownRequest(caller);
            } else {
                logger2.warning("Ignoring shutdown request from " + caller + " because it is not a member");
            }
        } else {
            logger2.warning("Received shutdown request from " + caller + " but this node is not master.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }
}

