/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class JoinCheckOperation
extends AbstractOperation
implements JoinOperation {
    private JoinMessage request;
    private JoinMessage response;
    private transient boolean removeCaller;

    public JoinCheckOperation() {
    }

    public JoinCheckOperation(JoinMessage request) {
        this.request = request;
    }

    @Override
    public void run() {
        block7: {
            ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            Node node = nodeEngine.getNode();
            if (!this.preCheck(node)) {
                return;
            }
            if (!this.masterCheck(node)) {
                return;
            }
            if (this.request != null) {
                ILogger logger2 = this.getLogger();
                try {
                    if (service.getClusterJoinManager().validateJoinMessage(this.request)) {
                        this.response = node.createSplitBrainJoinMessage();
                    }
                    if (logger2.isFineEnabled()) {
                        logger2.fine("Returning " + this.response + " to " + this.getCallerAddress());
                    }
                }
                catch (Exception e) {
                    if (!logger2.isFineEnabled()) break block7;
                    logger2.fine("Could not validate split-brain join message! -> " + e.getMessage());
                }
            }
        }
    }

    private boolean masterCheck(Node node) {
        ILogger logger2 = this.getLogger();
        Address caller = this.getCallerAddress();
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        if (node.isMaster()) {
            if (service.getMember(caller) != null) {
                logger2.info("Removing " + caller + ", since it thinks it's already split from this cluster " + "and looking to merge.");
                this.removeCaller = true;
            }
            return true;
        }
        service.getClusterHeartbeatManager().sendMasterConfirmation();
        logger2.info("Ignoring join check from " + caller + ", because this node is not master...");
        return false;
    }

    @Override
    public void afterRun() throws Exception {
        if (this.removeCaller) {
            ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
            Address caller = this.getCallerAddress();
            service.removeAddress(caller, "Removing " + caller + ", since it thinks it's already split from this cluster " + "and looking to merge.");
        }
    }

    private boolean preCheck(Node node) {
        ILogger logger2 = this.getLogger();
        if (!node.joined()) {
            logger2.info("Ignoring join check from " + this.getCallerAddress() + ", because this node is not joined to a cluster yet...");
            return false;
        }
        if (!node.isRunning()) {
            logger2.info("Ignoring join check from " + this.getCallerAddress() + ", because this node is not active...");
            return false;
        }
        ClusterState clusterState = node.clusterService.getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            logger2.info("Ignoring join check from " + this.getCallerAddress() + ", because cluster is in " + (Object)((Object)clusterState) + " state ...");
            return false;
        }
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.request = new JoinMessage();
        this.request.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.request.writeData(out);
    }
}

