/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.MulticastListener;
import com.hazelcast.internal.cluster.impl.NodeMulticastListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.util.EmptyStatement;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class MulticastService
implements Runnable {
    private static final int SEND_OUTPUT_SIZE = 1024;
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private static final int SOCKET_BUFFER_SIZE = 65536;
    private static final int SOCKET_TIMEOUT = 1000;
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 5;
    private final List<MulticastListener> listeners = new CopyOnWriteArrayList<MulticastListener>();
    private final Object sendLock = new Object();
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final ILogger logger;
    private final Node node;
    private final MulticastSocket multicastSocket;
    private final BufferObjectDataOutput sendOutput;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private volatile boolean running = true;

    private MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.logger = node.getLogger(MulticastService.class.getName());
        this.node = node;
        this.multicastSocket = multicastSocket;
        this.sendOutput = node.getSerializationService().createObjectDataOutput(1024);
        Config config = node.getConfig();
        MulticastConfig multicastConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
        this.datagramPacketSend = new DatagramPacket(new byte[0], 0, InetAddress.getByName(multicastConfig.getMulticastGroup()), multicastConfig.getMulticastPort());
        this.datagramPacketReceive = new DatagramPacket(new byte[65536], 65536);
    }

    public static MulticastService createMulticastService(Address bindAddress, Node node, Config config, ILogger logger2) {
        JoinConfig join = config.getNetworkConfig().getJoin();
        MulticastConfig multicastConfig = join.getMulticastConfig();
        if (!multicastConfig.isEnabled()) {
            return null;
        }
        MulticastService mcService = null;
        try {
            MulticastSocket multicastSocket = new MulticastSocket(null);
            multicastSocket.setReuseAddress(true);
            multicastSocket.bind(new InetSocketAddress(multicastConfig.getMulticastPort()));
            multicastSocket.setTimeToLive(multicastConfig.getMulticastTimeToLive());
            try {
                if (!bindAddress.getInetAddress().isLoopbackAddress()) {
                    multicastSocket.setInterface(bindAddress.getInetAddress());
                } else if (multicastConfig.isLoopbackModeEnabled()) {
                    multicastSocket.setLoopbackMode(true);
                    multicastSocket.setInterface(bindAddress.getInetAddress());
                }
            }
            catch (Exception e) {
                logger2.warning(e);
            }
            multicastSocket.setReceiveBufferSize(65536);
            multicastSocket.setSendBufferSize(65536);
            String multicastGroup = System.getProperty("hazelcast.multicast.group");
            if (multicastGroup == null) {
                multicastGroup = multicastConfig.getMulticastGroup();
            }
            multicastConfig.setMulticastGroup(multicastGroup);
            multicastSocket.joinGroup(InetAddress.getByName(multicastGroup));
            multicastSocket.setSoTimeout(1000);
            mcService = new MulticastService(node, multicastSocket);
            mcService.addMulticastListener(new NodeMulticastListener(node));
        }
        catch (Exception e) {
            logger2.severe(e);
        }
        return mcService;
    }

    public void addMulticastListener(MulticastListener multicastListener) {
        this.listeners.add(multicastListener);
    }

    public void removeMulticastListener(MulticastListener multicastListener) {
        this.listeners.remove(multicastListener);
    }

    public void stop() {
        try {
            if (!this.running && this.multicastSocket.isClosed()) {
                return;
            }
            try {
                this.multicastSocket.close();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            this.running = false;
            if (!this.stopLatch.await(5L, TimeUnit.SECONDS)) {
                this.logger.warning("Failed to shutdown MulticastService in 5 seconds!");
            }
        }
        catch (Throwable e) {
            this.logger.warning(e);
        }
    }

    private void cleanup() {
        this.running = false;
        try {
            this.sendOutput.close();
            this.datagramPacketReceive.setData(new byte[0]);
            this.datagramPacketSend.setData(new byte[0]);
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore(ignored);
        }
        this.stopLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                try {
                    JoinMessage joinMessage = this.receive();
                    if (joinMessage == null) continue;
                    for (MulticastListener multicastListener : this.listeners) {
                        try {
                            multicastListener.onMessage(joinMessage);
                        }
                        catch (Exception e) {
                            this.logger.warning(e);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                }
                catch (Exception e) {
                    this.logger.warning(e);
                }
            }
            return;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     */
    private JoinMessage receive() {
        JoinMessage joinMessage;
        try {
            this.multicastSocket.receive(this.datagramPacketReceive);
        }
        catch (IOException ignore) {
            return null;
        }
        byte[] data = this.datagramPacketReceive.getData();
        int offset = this.datagramPacketReceive.getOffset();
        BufferObjectDataInput input = this.node.getSerializationService().createObjectDataInput(data);
        input.position(offset);
        byte packetVersion = input.readByte();
        if (packetVersion != 4) {
            this.logger.warning("Received a JoinRequest with a different packet version! This -> 4, Incoming -> " + packetVersion + ", Sender -> " + this.datagramPacketReceive.getAddress());
            return null;
        }
        try {
            joinMessage = (JoinMessage)input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                    throw throwable;
                }
                catch (Exception e) {
                    if (!(e instanceof EOFException) && !(e instanceof HazelcastSerializationException)) {
                        throw e;
                    }
                    this.logger.warning("Received data format is invalid. (An old version of Hazelcast may be running here.)", e);
                }
            }
            catch (Exception e2) {
                this.logger.warning(e2);
            }
        }
        input.close();
        return joinMessage;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinMessage joinMessage) {
        if (!this.running) {
            return;
        }
        BufferObjectDataOutput out = this.sendOutput;
        Object object = this.sendLock;
        synchronized (object) {
            try {
                out.writeByte(4);
                out.writeObject(joinMessage);
                this.datagramPacketSend.setData(out.toByteArray());
                this.multicastSocket.send(this.datagramPacketSend);
                out.clear();
            }
            catch (IOException e) {
                this.logger.warning("You probably have too long Hazelcast configuration!", e);
            }
        }
    }
}

