/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.ModuleDefinitionCacheSingleton;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;

public class OSGiDirectoryBasedRepository
extends DirectoryBasedRepository {
    ModuleDefinitionCacheSingleton cache = ModuleDefinitionCacheSingleton.getInstance();

    public OSGiDirectoryBasedRepository(String name, File repository) {
        this(name, repository, true);
    }

    public OSGiDirectoryBasedRepository(String name, File repository, boolean isTimerThreadDaemon) {
        super(name, repository, isTimerThreadDaemon);
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
    }

    @Override
    protected ModuleDefinition loadJar(File jar) throws IOException {
        assert (jar.isFile());
        ModuleDefinition md = this.cache.get(jar.toURI());
        if (md != null) {
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINER, "OSGiDirectoryBasedRepository", "loadJar", "Found in mdCache for {0}", new Object[]{jar});
            }
            return md;
        }
        Manifest m = new JarFile(jar).getManifest();
        if (m != null) {
            this.cache.invalidate();
            if (m.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                Logger.logger.logp(Level.FINE, "OSGiDirectoryBasedRepository", "loadJar", "{0} is an OSGi bundle", new Object[]{jar});
                return this.newModuleDefinition(jar, null);
            }
        }
        return null;
    }

    @Override
    protected ModuleDefinition newModuleDefinition(File jar, Attributes attr) throws IOException {
        return new OSGiModuleDefinition(jar);
    }

    @Override
    protected void loadModuleDefs(Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
        if (this.cache.isCacheInvalidated()) {
            super.loadModuleDefs(moduleDefs, libraries);
        }
    }
}

