/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.resolution.InvariantTypes;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public class CovariantTypes {
    private CovariantTypes() {
    }

    public static boolean isAssignableFromAtLeastOne(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!CovariantTypes.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        if (type1 instanceof Class) {
            if (type2 instanceof Class) {
                return CovariantTypes.isAssignableFrom((Class)type1, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return CovariantTypes.isAssignableFrom((Class)type1, (ParameterizedType)type2);
            }
            if (type2 instanceof TypeVariable) {
                return CovariantTypes.isAssignableFrom((Class)type1, (TypeVariable)type2);
            }
            if (type2 instanceof WildcardType) {
                return CovariantTypes.isAssignableFrom((Class)type1, (WildcardType)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return CovariantTypes.isAssignableFrom((Class)type1, (GenericArrayType)type2);
            }
            throw ReflectionLogger.LOG.unknownType(type2);
        }
        if (type1 instanceof ParameterizedType) {
            if (type2 instanceof Class) {
                return CovariantTypes.isAssignableFrom((ParameterizedType)type1, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return CovariantTypes.isAssignableFrom((ParameterizedType)type1, (ParameterizedType)type2);
            }
            if (type2 instanceof TypeVariable) {
                return CovariantTypes.isAssignableFrom((ParameterizedType)type1, (TypeVariable)type2);
            }
            if (type2 instanceof WildcardType) {
                return CovariantTypes.isAssignableFrom((ParameterizedType)type1, (WildcardType)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return CovariantTypes.isAssignableFrom((ParameterizedType)type1, (GenericArrayType)type2);
            }
            throw ReflectionLogger.LOG.unknownType(type2);
        }
        if (type1 instanceof TypeVariable) {
            if (type2 instanceof Class) {
                return CovariantTypes.isAssignableFrom((TypeVariable)type1, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return CovariantTypes.isAssignableFrom((TypeVariable)type1, (ParameterizedType)type2);
            }
            if (type2 instanceof TypeVariable) {
                return CovariantTypes.isAssignableFrom((TypeVariable)type1, (TypeVariable)type2);
            }
            if (type2 instanceof WildcardType) {
                return CovariantTypes.isAssignableFrom((TypeVariable)type1, (WildcardType)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return CovariantTypes.isAssignableFrom((TypeVariable)type1, (GenericArrayType)type2);
            }
            throw ReflectionLogger.LOG.unknownType(type2);
        }
        if (type1 instanceof WildcardType) {
            if (Types.isActualType(type2)) {
                return CovariantTypes.isAssignableFrom((WildcardType)type1, type2);
            }
            if (type2 instanceof TypeVariable) {
                return CovariantTypes.isAssignableFrom((WildcardType)type1, (TypeVariable)type2);
            }
            if (type2 instanceof WildcardType) {
                return CovariantTypes.isAssignableFrom((WildcardType)type1, (WildcardType)type2);
            }
            throw ReflectionLogger.LOG.unknownType(type2);
        }
        if (type1 instanceof GenericArrayType) {
            if (type2 instanceof Class) {
                return CovariantTypes.isAssignableFrom((GenericArrayType)type1, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return CovariantTypes.isAssignableFrom((GenericArrayType)type1, (ParameterizedType)type2);
            }
            if (type2 instanceof TypeVariable) {
                return CovariantTypes.isAssignableFrom((GenericArrayType)type1, (TypeVariable)type2);
            }
            if (type2 instanceof WildcardType) {
                return CovariantTypes.isAssignableFrom((GenericArrayType)type1, (WildcardType)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return CovariantTypes.isAssignableFrom((GenericArrayType)type1, (GenericArrayType)type2);
            }
            throw ReflectionLogger.LOG.unknownType(type2);
        }
        throw ReflectionLogger.LOG.unknownType(type1);
    }

    private static boolean isAssignableFrom(Class<?> type1, Class<?> type2) {
        return Types.boxedClass(type1).isAssignableFrom(Types.boxedClass(type2));
    }

    private static boolean isAssignableFrom(Class<?> type1, ParameterizedType type2) {
        return type1.isAssignableFrom(Reflections.getRawType(type2));
    }

    private static boolean isAssignableFrom(Class<?> type1, TypeVariable<?> type2) {
        for (Type type3 : type2.getBounds()) {
            if (!CovariantTypes.isAssignableFrom(type1, type3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(Class<?> type1, WildcardType type2) {
        return false;
    }

    private static boolean isAssignableFrom(Class<?> type1, GenericArrayType type2) {
        return type1.equals(Object.class) || type1.isArray() && CovariantTypes.isAssignableFrom(type1.getComponentType(), Reflections.getRawType(type2.getGenericComponentType()));
    }

    private static boolean isAssignableFrom(ParameterizedType type1, Class<?> type2) {
        Class rawType1 = Reflections.getRawType(type1);
        if (!CovariantTypes.isAssignableFrom(rawType1, type2)) {
            return false;
        }
        if (!Types.getCanonicalType(type2).equals(type2)) {
            return true;
        }
        return CovariantTypes.matches(type1, new HierarchyDiscovery(type2));
    }

    private static boolean isAssignableFrom(ParameterizedType type1, ParameterizedType type2) {
        if (!CovariantTypes.isAssignableFrom(Reflections.getRawType(type1), Reflections.getRawType(type2))) {
            return false;
        }
        if (CovariantTypes.matches(type1, type2)) {
            return true;
        }
        return CovariantTypes.matches(type1, new HierarchyDiscovery(type2));
    }

    private static boolean matches(ParameterizedType type1, HierarchyDiscovery type2) {
        for (Type type3 : type2.getTypeClosure()) {
            if (!(type3 instanceof ParameterizedType) || !CovariantTypes.matches(type1, (ParameterizedType)type3)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(ParameterizedType type1, ParameterizedType type2) {
        Type[] types2;
        Class rawType2;
        Class rawType1 = Reflections.getRawType(type1);
        if (!rawType1.equals(rawType2 = Reflections.getRawType(type2))) {
            return false;
        }
        Type[] types1 = type1.getActualTypeArguments();
        if (types1.length != (types2 = type2.getActualTypeArguments()).length) {
            throw ReflectionLogger.LOG.invalidTypeArgumentCombination(type1, type2);
        }
        for (int i = 0; i < type1.getActualTypeArguments().length; ++i) {
            if (InvariantTypes.isAssignableFrom(types1[i], types2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, TypeVariable<?> type2) {
        for (Type type3 : type2.getBounds()) {
            if (!CovariantTypes.isAssignableFrom((Type)type1, type3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, WildcardType type2) {
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, GenericArrayType type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, Class<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, ParameterizedType type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, TypeVariable<?> type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (type2.getBounds()[0] instanceof TypeVariable) {
            return CovariantTypes.isAssignableFrom(type1, (TypeVariable)type2.getBounds()[0]);
        }
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, WildcardType type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, GenericArrayType type2) {
        return false;
    }

    private static boolean isAssignableFrom(WildcardType type1, Type type2) {
        if (!CovariantTypes.isAssignableFrom(type1.getUpperBounds()[0], type2)) {
            return false;
        }
        return type1.getLowerBounds().length <= 0 || CovariantTypes.isAssignableFrom(type2, type1.getLowerBounds()[0]);
    }

    private static boolean isAssignableFrom(WildcardType type1, TypeVariable<?> type2) {
        if (type1.getLowerBounds().length > 0) {
            return CovariantTypes.isAssignableFrom(type2, type1.getLowerBounds()[0]);
        }
        return CovariantTypes.isAssignableFrom(type1.getUpperBounds()[0], type2);
    }

    private static boolean isAssignableFrom(WildcardType type1, WildcardType type2) {
        if (!CovariantTypes.isAssignableFrom(type1.getUpperBounds()[0], type2.getUpperBounds()[0])) {
            return false;
        }
        if (type1.getLowerBounds().length > 0) {
            if (type2.getLowerBounds().length > 0) {
                return CovariantTypes.isAssignableFrom(type2.getLowerBounds()[0], type1.getLowerBounds()[0]);
            }
            return false;
        }
        if (type2.getLowerBounds().length > 0) {
            return type1.getUpperBounds()[0].equals(Object.class);
        }
        return true;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, Class<?> type2) {
        return type2.isArray() && CovariantTypes.isAssignableFrom(Reflections.getRawType(type1.getGenericComponentType()), type2.getComponentType());
    }

    private static boolean isAssignableFrom(GenericArrayType type1, ParameterizedType type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, TypeVariable<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, WildcardType type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, GenericArrayType type2) {
        return CovariantTypes.isAssignableFrom(type1.getGenericComponentType(), type2.getGenericComponentType());
    }
}

